/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class TimelineMetricUtils {
    public static String getJavaRegexFromSqlRegex(String sqlRegex) {
        String javaRegEx;
        if (sqlRegex.contains("*") || sqlRegex.contains("__%")) {
            String metricNameWithEscSeq = sqlRegex.replace("*", "\\*").replace("__%", "..%");
            javaRegEx = metricNameWithEscSeq.replace("%", ".*");
        } else {
            javaRegEx = sqlRegex.replace("%", ".*");
        }
        return javaRegEx;
    }

    public static List<String> getJavaMetricPatterns(String commaSeparatedMetricPatternsString) {
        ArrayList<String> javaPatterns = new ArrayList<String>();
        if (StringUtils.isEmpty(commaSeparatedMetricPatternsString)) {
            return javaPatterns;
        }
        for (String patternString : commaSeparatedMetricPatternsString.split(",")) {
            String javaPatternString = TimelineMetricUtils.getJavaRegexFromSqlRegex(patternString);
            javaPatterns.add(javaPatternString);
        }
        return javaPatterns;
    }
}

