/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.sink.timeline.MetadataException;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement(name="metric_metadata")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineMetricMetadata {
    private String metricName;
    private String appId;
    private String instanceId;
    private byte[] uuid;
    private String units;
    private String type = "UNDEFINED";
    private Long seriesStartTime;
    boolean supportsAggregates = true;
    boolean isWhitelisted = false;
    boolean isPersisted = false;

    public TimelineMetricMetadata() {
    }

    public TimelineMetricMetadata(String metricName, String appId, String instanceId, String units, String type, Long seriesStartTime, boolean supportsAggregates, boolean isWhitelisted) {
        this.metricName = metricName;
        this.appId = appId;
        this.instanceId = instanceId;
        this.units = units;
        this.type = type;
        this.seriesStartTime = seriesStartTime;
        this.supportsAggregates = supportsAggregates;
        this.isWhitelisted = isWhitelisted;
    }

    @XmlElement(name="metricname")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @XmlElement(name="instanceId")
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @XmlElement(name="uuid")
    public byte[] getUuid() {
        return this.uuid;
    }

    public void setUuid(byte[] uuid) {
        this.uuid = uuid;
    }

    @XmlElement(name="units")
    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @XmlElement(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name="seriesStartTime")
    public Long getSeriesStartTime() {
        return this.seriesStartTime != null ? this.seriesStartTime : 0L;
    }

    public void setSeriesStartTime(Long seriesStartTime) {
        this.seriesStartTime = seriesStartTime;
    }

    @XmlElement(name="supportsAggregation")
    public boolean isSupportsAggregates() {
        return this.supportsAggregates;
    }

    @XmlElement(name="isWhitelisted")
    public boolean isWhitelisted() {
        return this.isWhitelisted;
    }

    public void setIsWhitelisted(boolean isWhitelisted) {
        this.isWhitelisted = isWhitelisted;
    }

    public void setSupportsAggregates(boolean supportsAggregates) {
        this.supportsAggregates = supportsAggregates;
    }

    @JsonIgnore
    public boolean isPersisted() {
        return this.isPersisted;
    }

    public void setIsPersisted(boolean isPersisted) {
        this.isPersisted = isPersisted;
    }

    public boolean needsToBeSynced(TimelineMetricMetadata metadata) throws MetadataException {
        if (!(this.metricName.equals(metadata.getMetricName()) && this.appId.equals(metadata.getAppId()) && (!StringUtils.isNotEmpty(this.instanceId) ? StringUtils.isEmpty(metadata.instanceId) : this.instanceId.equals(metadata.instanceId)))) {
            throw new MetadataException("Unexpected argument: metricName = " + metadata.getMetricName() + ", appId = " + metadata.getAppId() + ", instanceId = " + metadata.getInstanceId());
        }
        return this.units != null && !this.units.equals(metadata.getUnits()) || this.type != null && !this.type.equals(metadata.getType()) || !this.supportsAggregates == metadata.isSupportsAggregates() || this.isWhitelisted != metadata.isWhitelisted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineMetricMetadata that = (TimelineMetricMetadata)o;
        if (!this.metricName.equals(that.metricName)) {
            return false;
        }
        if (!this.appId.equals(that.appId)) {
            return false;
        }
        return StringUtils.isNotEmpty(this.instanceId) ? this.instanceId.equals(that.instanceId) : StringUtils.isEmpty(that.instanceId);
    }

    public int hashCode() {
        int result = this.metricName.hashCode();
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        return result;
    }

    public static enum MetricType {
        GAUGE,
        COUNTER,
        UNDEFINED;

    }
}

