/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import org.apache.hadoop.metrics2.sink.timeline.MetricAggregate;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class MetricHostAggregate
extends MetricAggregate {
    private long numberOfSamples = 0L;

    @JsonCreator
    public MetricHostAggregate() {
        super(0.0, 0.0, (Double)Double.MIN_VALUE, (Double)Double.MAX_VALUE);
    }

    public MetricHostAggregate(Double sum, int numberOfSamples, Double deviation, Double max, Double min) {
        super(sum, deviation, max, min);
        this.numberOfSamples = numberOfSamples;
    }

    @JsonProperty(value="numberOfSamples")
    public long getNumberOfSamples() {
        return this.numberOfSamples == 0L ? 1L : this.numberOfSamples;
    }

    public void updateNumberOfSamples(long count) {
        this.numberOfSamples += count;
    }

    public void setNumberOfSamples(long numberOfSamples) {
        this.numberOfSamples = numberOfSamples;
    }

    public double calculateAverage() {
        return this.sum / (double)this.numberOfSamples;
    }

    public void updateAggregates(MetricHostAggregate hostAggregate) {
        this.updateMax(hostAggregate.getMax());
        this.updateMin(hostAggregate.getMin());
        this.updateSum(hostAggregate.getSum());
        this.updateNumberOfSamples(hostAggregate.getNumberOfSamples());
    }

    public String toString() {
        return "MetricHostAggregate{sum=" + this.sum + ", numberOfSamples=" + this.numberOfSamples + ", deviation=" + this.deviation + ", max=" + this.max + ", min=" + this.min + "}";
    }
}

