/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.logfeeder.docker.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ambari.logfeeder.docker.command.CommandExecutionHelper;
import org.apache.ambari.logfeeder.docker.command.CommandResponse;
import org.apache.ambari.logfeeder.docker.command.ContainerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerListContainerCommand
implements ContainerCommand<List<String>> {
    private static final Logger logger = LoggerFactory.getLogger(DockerListContainerCommand.class);

    @Override
    public List<String> execute(Map<String, String> params) {
        CommandResponse commandResponse = null;
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("/usr/local/bin/docker");
        commandList.add("ps");
        commandList.add("-a");
        commandList.add("-q");
        try {
            commandResponse = CommandExecutionHelper.executeCommand(commandList, null);
            if (commandResponse.getExitCode() != 0) {
                logger.error("Error during inspect containers request: {} (exit code: {})", (Object)commandResponse.getStdErr(), (Object)commandResponse.getExitCode());
            }
        }
        catch (Exception e) {
            logger.error("Error during inspect containers request", (Throwable)e);
        }
        return commandResponse != null ? commandResponse.getStdOut() : null;
    }
}

