/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.logfeeder.docker.command;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ambari.logfeeder.docker.command.CommandResponse;

public class CommandExecutionHelper {
    public static CommandResponse executeCommand(List<String> commands, Map<String, String> envMap) throws Exception {
        ProcessBuilder processBuilder = new ProcessBuilder(commands);
        Map<String, String> env = processBuilder.environment();
        if (envMap != null) {
            env.putAll(envMap);
        }
        Process shell = processBuilder.start();
        BufferedReader stdInput = new BufferedReader(new InputStreamReader(shell.getInputStream()));
        BufferedReader stdError = new BufferedReader(new InputStreamReader(shell.getErrorStream()));
        ArrayList<String> stdOutLines = new ArrayList<String>();
        StringBuilder errOut = new StringBuilder();
        String s = null;
        while ((s = stdInput.readLine()) != null) {
            stdOutLines.add(s);
        }
        while ((s = stdError.readLine()) != null) {
            errOut.append(s);
        }
        int exitCode = shell.waitFor();
        return new CommandResponse(exitCode, stdOutLines, errOut.toString());
    }
}

