/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.logfeeder.docker;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ambari.logfeeder.ContainerRegistry;
import org.apache.ambari.logfeeder.docker.DockerMetadata;
import org.apache.ambari.logfeeder.docker.command.DockerInspectContainerCommand;
import org.apache.ambari.logfeeder.docker.command.DockerListContainerCommand;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DockerContainerRegistry
implements ContainerRegistry<DockerMetadata> {
    private static final String LOGFEEDER_CONTAINER_REGISTRY_DOCKER_INTERVAL = "logfeeder.container.registry.docker.interval";
    private static final Logger logger = LoggerFactory.getLogger(DockerContainerRegistry.class);
    private static DockerContainerRegistry INSTANCE = null;
    private final Properties configs;
    private Map<String, Map<String, DockerMetadata>> dockerMetadataMap = new ConcurrentHashMap<String, Map<String, DockerMetadata>>();
    private int waitIntervalMin = 5;

    private DockerContainerRegistry(Properties configs) {
        this.configs = configs;
        this.init(configs);
    }

    @Override
    public synchronized void register() {
        Map<String, Map<String, DockerMetadata>> actualDockerMetadataMap = this.renewMetadata();
        if (!actualDockerMetadataMap.isEmpty()) {
            this.dockerMetadataMap.putAll(actualDockerMetadataMap);
            this.dockerMetadataMap = this.dockerMetadataMap.entrySet().stream().filter(e -> actualDockerMetadataMap.keySet().contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            for (Map.Entry<String, Map<String, DockerMetadata>> entry : this.dockerMetadataMap.entrySet()) {
                for (Map.Entry<String, DockerMetadata> metadataEntry : entry.getValue().entrySet()) {
                    logger.debug("Found container metadata: {}", (Object)entry.getValue().toString());
                }
            }
        }
    }

    private Map<String, Map<String, DockerMetadata>> renewMetadata() {
        HashMap<String, Map<String, DockerMetadata>> actualDockerMetadataMap = new HashMap<String, Map<String, DockerMetadata>>();
        Object containerIds = new DockerListContainerCommand().execute((Map)null);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("containerIds", StringUtils.join((Collection)containerIds, (String)","));
        Object containerDataList = new DockerInspectContainerCommand().execute(params);
        Iterator iterator = containerDataList.iterator();
        while (iterator.hasNext()) {
            long timestamp;
            Map containerDataMap = (Map)iterator.next();
            String id = containerDataMap.get("Id").toString();
            String name = containerDataMap.get("Name").toString();
            String logPath = containerDataMap.get("LogPath").toString();
            HashMap dockerConfigMap = (HashMap)containerDataMap.get("Config");
            String hostname = dockerConfigMap.get("Hostname").toString();
            Map labels = (Map)dockerConfigMap.get("Labels");
            HashMap stateMap = (HashMap)containerDataMap.get("State");
            String componentType = (String)labels.get("logfeeder.log.type");
            boolean running = (Boolean)stateMap.get("Running");
            long l = timestamp = running ? this.convertDateStrToLong((String)stateMap.get("StartedAt")) : this.convertDateStrToLong((String)stateMap.get("FinishedAt"));
            if (componentType != null) {
                Map<String, DockerMetadata> componentMetadataMap;
                if (actualDockerMetadataMap.containsKey(componentType)) {
                    componentMetadataMap = (Map)actualDockerMetadataMap.get(componentType);
                    componentMetadataMap.put(id, new DockerMetadata(id, name, hostname, componentType, logPath, running, timestamp));
                    actualDockerMetadataMap.put(componentType, componentMetadataMap);
                    continue;
                }
                componentMetadataMap = new HashMap();
                componentMetadataMap.put(id, new DockerMetadata(id, name, hostname, componentType, logPath, running, timestamp));
                actualDockerMetadataMap.put(componentType, componentMetadataMap);
                continue;
            }
            logger.debug("Ignoring docker metadata from registry as container (id: {}, name: {}) as it has no 'logfeeder.log.type' label", (Object)id, (Object)name);
        }
        return actualDockerMetadataMap;
    }

    @Override
    public synchronized Map<String, Map<String, DockerMetadata>> getContainerMetadataMap() {
        return this.dockerMetadataMap;
    }

    public void init(Properties configs) {
        String waitStr = configs.getProperty(LOGFEEDER_CONTAINER_REGISTRY_DOCKER_INTERVAL, "5");
        this.setWaitIntervalMin(Integer.parseInt(waitStr));
    }

    public static synchronized DockerContainerRegistry getInstance(Properties dockerConfig) {
        if (INSTANCE == null) {
            return new DockerContainerRegistry(dockerConfig);
        }
        return INSTANCE;
    }

    public int getWaitIntervalMin() {
        return this.waitIntervalMin;
    }

    public void setWaitIntervalMin(int waitIntervalMin) {
        this.waitIntervalMin = waitIntervalMin;
    }

    private long convertDateStrToLong(String timestampStr) {
        LocalDateTime localDateTime = LocalDateTime.parse(timestampStr, DateTimeFormatter.ISO_DATE_TIME);
        return localDateTime.toInstant(ZoneOffset.ofTotalSeconds(0)).toEpochMilli();
    }
}

