/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.logfeeder.docker.command;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.ambari.logfeeder.docker.command.CommandExecutionHelper;
import org.apache.ambari.logfeeder.docker.command.CommandResponse;
import org.apache.ambari.logfeeder.docker.command.ContainerCommand;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerInspectContainerCommand
implements ContainerCommand<List<Map<String, Object>>> {
    private static final Logger logger = LoggerFactory.getLogger(DockerInspectContainerCommand.class);

    @Override
    public List<Map<String, Object>> execute(Map<String, String> params) {
        List<String> containerIds = Arrays.asList(params.get("containerIds").split(","));
        CommandResponse commandResponse = null;
        List<Map<String, Object>> listResponse = new ArrayList<Map<String, Object>>();
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add("/usr/local/bin/docker");
        commandList.add("inspect");
        commandList.addAll(containerIds);
        try {
            commandResponse = CommandExecutionHelper.executeCommand(commandList, null);
            if (commandResponse.getExitCode() != 0) {
                logger.error("Error during inspect containers request: {} (exit code: {})", (Object)commandResponse.getStdErr(), (Object)commandResponse.getExitCode());
            } else {
                String jsonResponse = StringUtils.join(commandResponse.getStdOut(), (String)"");
                ObjectMapper mapper = new ObjectMapper();
                listResponse = (List)mapper.readValue(jsonResponse, List.class);
            }
        }
        catch (Exception e) {
            logger.error("Error during inspect containers request", (Throwable)e);
        }
        return listResponse;
    }
}

