/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ambari.logfeeder.docker;

import org.apache.ambari.logfeeder.docker.DockerContainerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerContainerRegistryMonitor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(DockerContainerRegistryMonitor.class);
    private final DockerContainerRegistry registry;

    public DockerContainerRegistryMonitor(DockerContainerRegistry registry) {
        this.registry = registry;
    }

    @Override
    public void run() {
        while (!Thread.currentThread().isInterrupted()) {
            try {
                logger.debug("Gather docker containers metadata ...");
                this.registry.register();
                Thread.sleep(1000 * this.registry.getWaitIntervalMin());
            }
            catch (Exception e) {
                logger.error("Error during gather docker containers metadata.", (Throwable)e);
            }
        }
    }
}

