/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.shell.commands;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.client.AccumuloException;
import org.apache.accumulo.core.client.AccumuloSecurityException;
import org.apache.accumulo.core.client.Connector;
import org.apache.accumulo.core.security.Authorizations;
import org.apache.accumulo.shell.Shell;
import org.apache.accumulo.shell.Token;
import org.apache.accumulo.shell.commands.ScanCommand;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;

public class DeleteAuthsCommand
extends Shell.Command {
    private Option userOpt;
    private Option scanOptAuths;

    @Override
    public int execute(String fullCommand, CommandLine cl, Shell shellState) throws AccumuloException, AccumuloSecurityException {
        String[] existingAuths;
        Connector connector = shellState.getConnector();
        String user = cl.getOptionValue(this.userOpt.getOpt(), connector.whoami());
        String scanOpts = cl.getOptionValue(this.scanOptAuths.getOpt());
        Authorizations auths = connector.securityOperations().getUserAuthorizations(user);
        StringBuilder userAuths = new StringBuilder();
        String[] toBeRemovedAuths = scanOpts.split(",");
        HashSet<String> toBeRemovedSet = new HashSet<String>();
        for (String auth : toBeRemovedAuths) {
            toBeRemovedSet.add(auth);
        }
        for (String auth : existingAuths = auths.toString().split(",")) {
            if (toBeRemovedSet.contains(auth)) continue;
            userAuths.append(auth);
            userAuths.append(",");
        }
        if (userAuths.length() > 0) {
            connector.securityOperations().changeUserAuthorizations(user, ScanCommand.parseAuthorizations(userAuths.substring(0, userAuths.length() - 1)));
        } else {
            connector.securityOperations().changeUserAuthorizations(user, new Authorizations());
        }
        Shell.log.debug((Object)("Changed record-level authorizations for user " + user));
        return 0;
    }

    @Override
    public String description() {
        return "remove authorizations from the maximum scan authorizations for a user";
    }

    @Override
    public void registerCompletion(Token root, Map<Shell.Command.CompletionSet, Set<String>> completionSet) {
        this.registerCompletionForUsers(root, completionSet);
    }

    @Override
    public Options getOptions() {
        Options o = new Options();
        OptionGroup setOrClear = new OptionGroup();
        this.scanOptAuths = new Option("s", "scan-authorizations", true, "scan authorizations to remove");
        this.scanOptAuths.setArgName("comma-separated-authorizations");
        setOrClear.addOption(this.scanOptAuths);
        setOrClear.setRequired(true);
        o.addOptionGroup(setOrClear);
        this.userOpt = new Option("u", "user", true, "user to operate on");
        this.userOpt.setArgName("user");
        o.addOption(this.userOpt);
        return o;
    }

    @Override
    public int numArgs() {
        return 0;
    }
}

