/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.security;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.Property;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserImpersonation {
    private static final Logger log = LoggerFactory.getLogger(UserImpersonation.class);
    private static final Set<String> ALWAYS_TRUE = new AlwaysTrueSet<String>();
    private static final String ALL = "*";
    private static final String USERS = "users";
    private static final String HOSTS = "hosts";
    private final Map<String, UsersWithHosts> proxyUsers = new HashMap<String, UsersWithHosts>();

    public UserImpersonation(AccumuloConfiguration conf) {
        String userConfig = conf.get(Property.INSTANCE_RPC_SASL_ALLOWED_USER_IMPERSONATION);
        if (!Property.INSTANCE_RPC_SASL_ALLOWED_USER_IMPERSONATION.getDefaultValue().equals(userConfig)) {
            String hostConfig = conf.get(Property.INSTANCE_RPC_SASL_ALLOWED_HOST_IMPERSONATION);
            this.parseOnelineConfiguration(userConfig, hostConfig);
        } else {
            this.parseMultiPropertyConfiguration(conf.getAllPropertiesWithPrefix(Property.INSTANCE_RPC_SASL_PROXYUSERS));
        }
    }

    private void parseOnelineConfiguration(String userConfigString, String hostConfigString) {
        String[] hostConfigs;
        String[] userConfigs = userConfigString.trim().isEmpty() ? new String[]{""} : StringUtils.split((String)userConfigString, (char)';');
        if (userConfigs.length != (hostConfigs = hostConfigString.trim().isEmpty() ? new String[]{""} : StringUtils.split((String)hostConfigString, (char)';')).length) {
            String msg = String.format("Should have equal number of user and host impersonation elements in configuration. Got %d and %d elements, respectively.", userConfigs.length, hostConfigs.length);
            throw new IllegalArgumentException(msg);
        }
        for (int i = 0; i < userConfigs.length; ++i) {
            String userConfig = userConfigs[i];
            String hostConfig = hostConfigs[i];
            String[] splitUserConfig = StringUtils.split((String)userConfig, (char)':');
            if (2 != splitUserConfig.length) {
                throw new IllegalArgumentException("Expect a single colon-separated pair, but found '" + userConfig + "'");
            }
            String remoteUser = splitUserConfig[0];
            String allowedImpersonationsForRemoteUser = splitUserConfig[1];
            UsersWithHosts usersWithHosts = new UsersWithHosts();
            this.proxyUsers.put(remoteUser.trim(), usersWithHosts);
            if (ALL.equals(allowedImpersonationsForRemoteUser)) {
                usersWithHosts.setAcceptAllUsers(true);
            } else {
                String[] allowedUsers = StringUtils.split((String)allowedImpersonationsForRemoteUser, (String)",");
                HashSet<String> usersSet = new HashSet<String>();
                usersSet.addAll(Arrays.asList(allowedUsers));
                usersWithHosts.setUsers(usersSet);
            }
            if (ALL.equals(hostConfig)) {
                usersWithHosts.setAcceptAllHosts(true);
                continue;
            }
            String[] allowedHosts = StringUtils.split((String)hostConfig, (String)",");
            HashSet<String> hostsSet = new HashSet<String>();
            hostsSet.addAll(Arrays.asList(allowedHosts));
            usersWithHosts.setHosts(hostsSet);
        }
    }

    private void parseMultiPropertyConfiguration(Map<String, String> configProperties) {
        String configKey = Property.INSTANCE_RPC_SASL_PROXYUSERS.getKey();
        for (Map.Entry<String, String> entry : configProperties.entrySet()) {
            String aclKey = entry.getKey().substring(configKey.length());
            int index = aclKey.lastIndexOf(46);
            if (-1 == index) {
                throw new RuntimeException("Expected 2 elements in key suffix: " + aclKey);
            }
            String remoteUser = aclKey.substring(0, index).trim();
            String usersOrHosts = aclKey.substring(index + 1).trim();
            UsersWithHosts usersWithHosts = this.proxyUsers.get(remoteUser);
            if (null == usersWithHosts) {
                usersWithHosts = new UsersWithHosts();
                this.proxyUsers.put(remoteUser, usersWithHosts);
            }
            if (USERS.equals(usersOrHosts)) {
                String userString = entry.getValue().trim();
                if (ALL.equals(userString)) {
                    usersWithHosts.setAcceptAllUsers(true);
                    continue;
                }
                if (usersWithHosts.acceptsAllUsers()) continue;
                Set<String> users = usersWithHosts.getUsers();
                if (null == users) {
                    users = new HashSet<String>();
                    usersWithHosts.setUsers(users);
                }
                String[] userValues = StringUtils.split((String)userString, (char)',');
                users.addAll(Arrays.asList(userValues));
                continue;
            }
            if (HOSTS.equals(usersOrHosts)) {
                String hostsString = entry.getValue().trim();
                if (ALL.equals(hostsString)) {
                    usersWithHosts.setAcceptAllHosts(true);
                    continue;
                }
                if (usersWithHosts.acceptsAllHosts()) continue;
                Set<String> hosts = usersWithHosts.getHosts();
                if (null == hosts) {
                    hosts = new HashSet<String>();
                    usersWithHosts.setHosts(hosts);
                }
                String[] hostValues = StringUtils.split((String)hostsString, (char)',');
                hosts.addAll(Arrays.asList(hostValues));
                continue;
            }
            log.debug("Ignoring key " + aclKey);
        }
    }

    public UsersWithHosts get(String remoteUser) {
        return this.proxyUsers.get(remoteUser);
    }

    public static class UsersWithHosts {
        private Set<String> users = new HashSet<String>();
        private Set<String> hosts = new HashSet<String>();
        private boolean allUsers = false;
        private boolean allHosts = false;

        public UsersWithHosts() {
        }

        public UsersWithHosts(Set<String> users, Set<String> hosts) {
            this();
            this.users = users;
            this.hosts = hosts;
        }

        public Set<String> getUsers() {
            if (this.allUsers) {
                return ALWAYS_TRUE;
            }
            return this.users;
        }

        public Set<String> getHosts() {
            if (this.allHosts) {
                return ALWAYS_TRUE;
            }
            return this.hosts;
        }

        public boolean acceptsAllUsers() {
            return this.allUsers;
        }

        public void setAcceptAllUsers(boolean allUsers) {
            this.allUsers = allUsers;
        }

        public boolean acceptsAllHosts() {
            return this.allHosts;
        }

        public void setAcceptAllHosts(boolean allHosts) {
            this.allHosts = allHosts;
        }

        public void setUsers(Set<String> users) {
            this.users = users;
            this.allUsers = false;
        }

        public void setHosts(Set<String> hosts) {
            this.hosts = hosts;
            this.allHosts = false;
        }
    }

    public static class AlwaysTrueSet<T>
    implements Set<T> {
        @Override
        public int size() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEmpty() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(Object o) {
            return true;
        }

        @Override
        public Iterator<T> iterator() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Object[] toArray() {
            throw new UnsupportedOperationException();
        }

        @Override
        public <E> E[] toArray(E[] a) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return true;
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }
}

