/*
 * Decompiled with CFR 0.152.
 */
package org.apache.accumulo.server.master.balancer;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.accumulo.core.client.admin.TableOperations;
import org.apache.accumulo.core.conf.AccumuloConfiguration;
import org.apache.accumulo.core.conf.ConfigurationObserver;
import org.apache.accumulo.core.conf.Property;
import org.apache.accumulo.core.data.impl.KeyExtent;
import org.apache.accumulo.core.master.thrift.TableInfo;
import org.apache.accumulo.core.master.thrift.TabletServerStatus;
import org.apache.accumulo.core.tabletserver.thrift.TabletStats;
import org.apache.accumulo.server.conf.ServerConfiguration;
import org.apache.accumulo.server.conf.ServerConfigurationFactory;
import org.apache.accumulo.server.master.balancer.TableLoadBalancer;
import org.apache.accumulo.server.master.state.TServerInstance;
import org.apache.accumulo.server.master.state.TabletMigration;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostRegexTableLoadBalancer
extends TableLoadBalancer
implements ConfigurationObserver {
    private static final String PROP_PREFIX = Property.TABLE_ARBITRARY_PROP_PREFIX.getKey();
    private static final Logger LOG = LoggerFactory.getLogger(HostRegexTableLoadBalancer.class);
    public static final String HOST_BALANCER_PREFIX = PROP_PREFIX + "balancer.host.regex.";
    public static final String HOST_BALANCER_OOB_CHECK_KEY = PROP_PREFIX + "balancer.host.regex.oob.period";
    private static final String HOST_BALANCER_OOB_DEFAULT = "5m";
    @Deprecated
    public static final String HOST_BALANCER_POOL_RECHECK_KEY = PROP_PREFIX + "balancer.host.regex.pool.check";
    public static final String HOST_BALANCER_REGEX_USING_IPS_KEY = PROP_PREFIX + "balancer.host.regex.is.ip";
    public static final String HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY = PROP_PREFIX + "balancer.host.regex.concurrent.migrations";
    private static final int HOST_BALANCER_REGEX_MAX_MIGRATIONS_DEFAULT = 250;
    protected static final String DEFAULT_POOL = "HostTableLoadBalancer.ALL";
    private static final int DEFAULT_OUTSTANDING_MIGRATIONS = 0;
    public static final String HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY = PROP_PREFIX + "balancer.host.regex.max.outstanding.migrations";
    protected long oobCheckMillis = AccumuloConfiguration.getTimeInMillis((String)"5m");
    private static final long ONE_HOUR = 3600000L;
    private static final Set<KeyExtent> EMPTY_MIGRATIONS = Collections.emptySet();
    private volatile Map<String, String> tableIdToTableName = null;
    private volatile Map<String, Pattern> poolNameToRegexPattern = null;
    private volatile long lastOOBCheck = System.currentTimeMillis();
    private volatile boolean isIpBasedRegex = false;
    private Map<String, SortedMap<TServerInstance, TabletServerStatus>> pools = new HashMap<String, SortedMap<TServerInstance, TabletServerStatus>>();
    private volatile int maxTServerMigrations = 250;
    private volatile int maxOutstandingMigrations = 0;
    private final Map<KeyExtent, TabletMigration> migrationsFromLastPass = new HashMap<KeyExtent, TabletMigration>();
    private final Map<String, Long> tableToTimeSinceNoMigrations = new HashMap<String, Long>();

    protected synchronized Map<String, SortedMap<TServerInstance, TabletServerStatus>> splitCurrentByRegex(SortedMap<TServerInstance, TabletServerStatus> current) {
        LOG.debug("Performing pool recheck - regrouping tablet servers based on regular expressions");
        HashMap<String, SortedMap<TServerInstance, TabletServerStatus>> newPools = new HashMap<String, SortedMap<TServerInstance, TabletServerStatus>>();
        for (Map.Entry<TServerInstance, TabletServerStatus> entry : current.entrySet()) {
            List<String> poolNames = this.getPoolNamesForHost(entry.getKey().host());
            for (String pool : poolNames) {
                TreeMap<TServerInstance, TabletServerStatus> np = (TreeMap<TServerInstance, TabletServerStatus>)newPools.get(pool);
                if (null == np) {
                    np = new TreeMap<TServerInstance, TabletServerStatus>(current.comparator());
                    newPools.put(pool, np);
                }
                np.put(entry.getKey(), entry.getValue());
            }
        }
        if (newPools.get(DEFAULT_POOL) == null) {
            LOG.warn("Default pool is empty; assigning all tablet servers to the default pool");
            TreeMap<TServerInstance, TabletServerStatus> dp = new TreeMap<TServerInstance, TabletServerStatus>(current.comparator());
            dp.putAll(current);
            newPools.put(DEFAULT_POOL, dp);
        }
        this.pools = newPools;
        LOG.trace("Pool to TabletServer mapping:");
        if (LOG.isTraceEnabled()) {
            for (Map.Entry<Object, Object> entry : this.pools.entrySet()) {
                LOG.trace("\tpool: {} -> tservers: {}", entry.getKey(), ((SortedMap)entry.getValue()).keySet());
            }
        }
        return this.pools;
    }

    protected List<String> getPoolNamesForHost(String host) {
        String test = host;
        if (!this.isIpBasedRegex) {
            try {
                test = this.getNameFromIp(host);
            }
            catch (UnknownHostException e1) {
                LOG.error("Unable to determine host name for IP: " + host + ", setting to default pool", (Throwable)e1);
                return Collections.singletonList(DEFAULT_POOL);
            }
        }
        ArrayList<String> pools = new ArrayList<String>();
        for (Map.Entry<String, Pattern> e : this.poolNameToRegexPattern.entrySet()) {
            if (!e.getValue().matcher(test).matches()) continue;
            pools.add(e.getKey());
        }
        if (pools.size() == 0) {
            pools.add(DEFAULT_POOL);
        }
        return pools;
    }

    protected String getNameFromIp(String hostIp) throws UnknownHostException {
        return InetAddress.getByName(hostIp).getHostName();
    }

    protected String getPoolNameForTable(String tableName) {
        if (null == tableName) {
            return DEFAULT_POOL;
        }
        return this.poolNameToRegexPattern.containsKey(tableName) ? tableName : DEFAULT_POOL;
    }

    protected void parseConfiguration(ServerConfiguration conf) {
        String outstanding;
        String migrations;
        String ipBased;
        TableOperations t = this.getTableOperations();
        if (null == t) {
            throw new RuntimeException("Table Operations cannot be null");
        }
        HashMap<String, String> tableIdToTableNameBuilder = new HashMap<String, String>();
        HashMap<String, Pattern> poolNameToRegexPatternBuilder = new HashMap<String, Pattern>();
        for (Map.Entry table : t.tableIdMap().entrySet()) {
            tableIdToTableNameBuilder.put((String)table.getValue(), (String)table.getKey());
            conf.getTableConfiguration((String)table.getValue()).addObserver(this);
            Map customProps = conf.getTableConfiguration((String)table.getValue()).getAllPropertiesWithPrefix(Property.TABLE_ARBITRARY_PROP_PREFIX);
            if (null == customProps || customProps.size() <= 0) continue;
            for (Map.Entry customProp : customProps.entrySet()) {
                if (!((String)customProp.getKey()).startsWith(HOST_BALANCER_PREFIX) || ((String)customProp.getKey()).equals(HOST_BALANCER_OOB_CHECK_KEY) || ((String)customProp.getKey()).equals(HOST_BALANCER_REGEX_USING_IPS_KEY) || ((String)customProp.getKey()).equals(HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY) || ((String)customProp.getKey()).equals(HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY)) continue;
                String tableName = ((String)customProp.getKey()).substring(HOST_BALANCER_PREFIX.length());
                String regex = (String)customProp.getValue();
                poolNameToRegexPatternBuilder.put(tableName, Pattern.compile(regex));
            }
        }
        this.tableIdToTableName = ImmutableMap.copyOf(tableIdToTableNameBuilder);
        this.poolNameToRegexPattern = ImmutableMap.copyOf(poolNameToRegexPatternBuilder);
        String oobProperty = conf.getConfiguration().get(HOST_BALANCER_OOB_CHECK_KEY);
        if (null != oobProperty) {
            this.oobCheckMillis = AccumuloConfiguration.getTimeInMillis((String)oobProperty);
        }
        if (null != (ipBased = conf.getConfiguration().get(HOST_BALANCER_REGEX_USING_IPS_KEY))) {
            this.isIpBasedRegex = Boolean.parseBoolean(ipBased);
        }
        if (null != (migrations = conf.getConfiguration().get(HOST_BALANCER_REGEX_MAX_MIGRATIONS_KEY))) {
            this.maxTServerMigrations = Integer.parseInt(migrations);
        }
        if (null != (outstanding = conf.getConfiguration().get(HOST_BALANCER_OUTSTANDING_MIGRATIONS_KEY))) {
            this.maxOutstandingMigrations = Integer.parseInt(outstanding);
        }
        LOG.info("{}", (Object)this);
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        buf.append("\nTablet Out Of Bounds Check Interval", this.oobCheckMillis);
        buf.append("\nMax Tablet Server Migrations", this.maxTServerMigrations);
        buf.append("\nRegular Expressions use IPs", this.isIpBasedRegex);
        buf.append("\nPools", this.poolNameToRegexPattern);
        return buf.toString();
    }

    public Map<String, String> getTableIdToTableName() {
        return this.tableIdToTableName;
    }

    public Map<String, Pattern> getPoolNameToRegexPattern() {
        return this.poolNameToRegexPattern;
    }

    public int getMaxMigrations() {
        return this.maxTServerMigrations;
    }

    public int getMaxOutstandingMigrations() {
        return this.maxOutstandingMigrations;
    }

    public long getOobCheckMillis() {
        return this.oobCheckMillis;
    }

    @Deprecated
    public long getPoolRecheckMillis() {
        return 0L;
    }

    public boolean isIpBasedRegex() {
        return this.isIpBasedRegex;
    }

    public int getMaxConcurrentMigrations() {
        return this.maxTServerMigrations;
    }

    @Override
    public void init(ServerConfigurationFactory conf) {
        super.init(conf);
        this.parseConfiguration(conf);
    }

    @Override
    public void getAssignments(SortedMap<TServerInstance, TabletServerStatus> current, Map<KeyExtent, TServerInstance> unassigned, Map<KeyExtent, TServerInstance> assignments) {
        Map<String, SortedMap<TServerInstance, TabletServerStatus>> pools = this.splitCurrentByRegex(current);
        HashMap<String, HashMap<KeyExtent, TServerInstance>> groupedUnassigned = new HashMap<String, HashMap<KeyExtent, TServerInstance>>();
        for (Map.Entry<KeyExtent, TServerInstance> entry : unassigned.entrySet()) {
            HashMap<KeyExtent, TServerInstance> tableUnassigned = (HashMap<KeyExtent, TServerInstance>)groupedUnassigned.get(entry.getKey().getTableId());
            if (tableUnassigned == null) {
                tableUnassigned = new HashMap<KeyExtent, TServerInstance>();
                groupedUnassigned.put(entry.getKey().getTableId(), tableUnassigned);
            }
            tableUnassigned.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, TServerInstance> entry : groupedUnassigned.entrySet()) {
            HashMap<KeyExtent, TServerInstance> newAssignments = new HashMap<KeyExtent, TServerInstance>();
            String tableName = this.tableIdToTableName.get(entry.getKey());
            String poolName = this.getPoolNameForTable(tableName);
            SortedMap<TServerInstance, TabletServerStatus> currentView = pools.get(poolName);
            if (null == currentView || currentView.size() == 0) {
                LOG.warn("No tablet servers online for table {}, assigning within default pool", (Object)tableName);
                currentView = pools.get(DEFAULT_POOL);
                if (null == currentView) {
                    LOG.error("No tablet servers exist in the default pool, unable to assign tablets for table {}", (Object)tableName);
                    continue;
                }
            }
            LOG.debug("Sending {} tablets to balancer for table {} for assignment within tservers {}", new Object[]{((Map)((Object)entry.getValue())).size(), tableName, currentView.keySet()});
            this.getBalancerForTable((String)entry.getKey()).getAssignments(currentView, (Map)((Object)entry.getValue()), newAssignments);
            assignments.putAll(newAssignments);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long balance(SortedMap<TServerInstance, TabletServerStatus> current, Set<KeyExtent> migrations, List<TabletMigration> migrationsOut) {
        long minBalanceTime = 20000L;
        TableOperations t = this.getTableOperations();
        if (t == null) {
            return minBalanceTime;
        }
        Map tableIdMap = t.tableIdMap();
        long now = System.currentTimeMillis();
        Map<String, SortedMap<TServerInstance, TabletServerStatus>> currentGrouped = this.splitCurrentByRegex(current);
        if (now - this.lastOOBCheck > this.oobCheckMillis) {
            try {
                for (String table : t.list()) {
                    LOG.debug("Checking for out of bounds tablets for table {}", (Object)table);
                    String tablePoolName = this.getPoolNameForTable(table);
                    block6: for (Map.Entry<TServerInstance, TabletServerStatus> e : current.entrySet()) {
                        List<String> hostPools = this.getPoolNamesForHost(e.getKey().host());
                        if (hostPools.contains(tablePoolName)) continue;
                        String tid = (String)tableIdMap.get(table);
                        if (null == tid) {
                            LOG.warn("Unable to check for out of bounds tablets for table {}, it may have been deleted or renamed.", (Object)table);
                            continue;
                        }
                        try {
                            List<TabletStats> outOfBoundsTablets = this.getOnlineTabletsForTable(e.getKey(), tid);
                            if (null == outOfBoundsTablets) continue;
                            Random random = new Random();
                            for (TabletStats ts : outOfBoundsTablets) {
                                KeyExtent ke = new KeyExtent(ts.getExtent());
                                if (migrations.contains(ke)) {
                                    LOG.debug("Migration for out of bounds tablet {} has already been requested", (Object)ke);
                                    continue;
                                }
                                String poolName = this.getPoolNameForTable(table);
                                SortedMap<TServerInstance, TabletServerStatus> currentView = currentGrouped.get(poolName);
                                if (null != currentView) {
                                    int skip = random.nextInt(currentView.size());
                                    Iterator<TServerInstance> iter = currentView.keySet().iterator();
                                    for (int i = 0; i < skip; ++i) {
                                        iter.next();
                                    }
                                    TServerInstance nextTS = iter.next();
                                    LOG.info("Tablet {} is currently outside the bounds of the regex, migrating from {} to {}", new Object[]{ke, e.getKey(), nextTS});
                                    migrationsOut.add(new TabletMigration(ke, e.getKey(), nextTS));
                                    if (migrationsOut.size() < this.maxTServerMigrations) continue;
                                    continue block6;
                                }
                                LOG.warn("No tablet servers online for pool {}, unable to migrate out of bounds tablets", (Object)poolName);
                            }
                        }
                        catch (TException e1) {
                            LOG.error("Error in OOB check getting tablets for table {} from server {}", new Object[]{tid, e.getKey().host(), e});
                        }
                    }
                }
            }
            finally {
                this.lastOOBCheck = System.currentTimeMillis();
            }
        }
        if (migrationsOut.size() > 0) {
            LOG.warn("Not balancing tables due to moving {} out of bounds tablets", (Object)migrationsOut.size());
            LOG.info("Migrating out of bounds tablets: {}", migrationsOut);
            return minBalanceTime;
        }
        if (migrations != null && migrations.size() > 0) {
            if (migrations.size() >= this.maxOutstandingMigrations) {
                LOG.warn("Not balancing tables due to {} outstanding migrations", (Object)migrations.size());
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Sample up to 10 outstanding migrations: {}", (Object)Iterables.limit(migrations, (int)10));
                }
                return minBalanceTime;
            }
            LOG.debug("Current outstanding migrations of {} being applied", (Object)migrations.size());
            if (LOG.isTraceEnabled()) {
                LOG.trace("Sample up to 10 outstanding migrations: {}", (Object)Iterables.limit(migrations, (int)10));
            }
            this.migrationsFromLastPass.keySet().retainAll(migrations);
            TreeMap<TServerInstance, TabletServerStatus> currentCopy = new TreeMap<TServerInstance, TabletServerStatus>(current);
            HashMultimap serverTableIdCopied = HashMultimap.create();
            for (TabletMigration migration : this.migrationsFromLastPass.values()) {
                TableInfo toInfo;
                TableInfo fromInfo = this.getTableInfo(currentCopy, (Multimap<TServerInstance, String>)serverTableIdCopied, migration.tablet.getTableId().toString(), migration.oldServer);
                if (fromInfo != null) {
                    fromInfo.setOnlineTablets(fromInfo.getOnlineTablets() - 1);
                }
                if ((toInfo = this.getTableInfo(currentCopy, (Multimap<TServerInstance, String>)serverTableIdCopied, migration.tablet.getTableId().toString(), migration.newServer)) == null) continue;
                toInfo.setOnlineTablets(toInfo.getOnlineTablets() + 1);
            }
            migrations = EMPTY_MIGRATIONS;
        } else {
            this.migrationsFromLastPass.clear();
        }
        for (String s : tableIdMap.values()) {
            String tableName = this.tableIdToTableName.get(s);
            String regexTableName = this.getPoolNameForTable(tableName);
            SortedMap<TServerInstance, TabletServerStatus> currentView = currentGrouped.get(regexTableName);
            if (null == currentView) {
                LOG.warn("Skipping balance for table {} as no tablet servers are online.", (Object)tableName);
                continue;
            }
            ArrayList<TabletMigration> newMigrations = new ArrayList<TabletMigration>();
            this.getBalancerForTable(s).balance(currentView, migrations, newMigrations);
            if (newMigrations.isEmpty()) {
                this.tableToTimeSinceNoMigrations.remove(s);
            } else if (this.tableToTimeSinceNoMigrations.containsKey(s)) {
                if (now - this.tableToTimeSinceNoMigrations.get(s) > 3600000L) {
                    LOG.warn("We have been consistently producing migrations for {}: {}", (Object)tableName, (Object)Iterables.limit(newMigrations, (int)10));
                }
            } else {
                this.tableToTimeSinceNoMigrations.put(s, now);
            }
            migrationsOut.addAll(newMigrations);
            if (migrationsOut.size() < this.maxTServerMigrations) continue;
            break;
        }
        for (TabletMigration migration : migrationsOut) {
            this.migrationsFromLastPass.put(migration.tablet, migration);
        }
        LOG.info("Migrating tablets for balance: {}", migrationsOut);
        return minBalanceTime;
    }

    private TableInfo getTableInfo(SortedMap<TServerInstance, TabletServerStatus> currentCopy, Multimap<TServerInstance, String> serverTableIdCopied, String tableId, TServerInstance server) {
        HashMap<String, TableInfo> newTableMap;
        TableInfo newInfo = null;
        if (currentCopy.containsKey(server) && (newTableMap = ((TabletServerStatus)currentCopy.get(server)).getTableMap()) != null && (newInfo = (TableInfo)newTableMap.get(tableId)) != null) {
            Collection tableIdCopied = serverTableIdCopied.get((Object)server);
            if (tableIdCopied.isEmpty()) {
                newTableMap = new HashMap<String, TableInfo>(newTableMap);
                ((TabletServerStatus)currentCopy.get(server)).setTableMap(newTableMap);
            }
            if (!tableIdCopied.contains(tableId)) {
                newInfo = new TableInfo(newInfo);
                newTableMap.put(tableId, newInfo);
                tableIdCopied.add(tableId);
            }
        }
        return newInfo;
    }

    public void propertyChanged(String key) {
        this.parseConfiguration(this.configuration);
    }

    public void propertiesChanged() {
        this.parseConfiguration(this.configuration);
    }

    public void sessionExpired() {
    }
}

