/*
 * Decompiled with CFR 0.152.
 */
package net.jradius.client.auth;

import java.nio.ByteBuffer;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLException;
import net.jradius.client.RadiusClient;
import net.jradius.client.auth.CHAPAuthenticator;
import net.jradius.client.auth.EAPAuthenticator;
import net.jradius.client.auth.EAPTLSAuthenticator;
import net.jradius.client.auth.MSCHAPv1Authenticator;
import net.jradius.client.auth.MSCHAPv2Authenticator;
import net.jradius.client.auth.PAPAuthenticator;
import net.jradius.client.auth.RadiusAuthenticator;
import net.jradius.client.auth.TunnelAuthenticator;
import net.jradius.exception.RadiusException;
import net.jradius.log.RadiusLog;
import net.jradius.packet.AccessChallenge;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.DiameterFormat;
import net.jradius.packet.RadiusPacket;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;

public class EAPTTLSAuthenticator
extends EAPTLSAuthenticator
implements TunnelAuthenticator {
    public static final String NAME = "eap-ttls";
    private String innerProtocol = "pap";
    private RadiusAuthenticator tunnelAuth;
    private RadiusPacket tunnelRequest;
    private RadiusPacket tunnelChallenge;
    private AttributeList tunneledAttributes;
    private static final DiameterFormat diameterFormat = new DiameterFormat();

    public EAPTTLSAuthenticator() {
        this.setEAPType(21);
    }

    public void init() throws RadiusException {
        super.init();
        this.tunnelAuth = RadiusClient.getAuthProtocol((String)this.getInnerProtocol());
        if (this.tunnelAuth == null || this.tunnelAuth instanceof MSCHAPv2Authenticator || this.tunnelAuth instanceof MSCHAPv1Authenticator || this.tunnelAuth instanceof CHAPAuthenticator) {
            throw new RadiusException("You can not currently use " + this.tunnelAuth.getAuthName() + " within a TLS Tunnel because of limitations in Java 1.5.");
        }
    }

    protected boolean isCertificateRequired() {
        return false;
    }

    public String getAuthName() {
        return NAME;
    }

    public void setTunneledAttributes(AttributeList tunneledAttributes) {
        this.tunneledAttributes = tunneledAttributes;
    }

    public void setupRequest(RadiusClient c, RadiusPacket p) throws RadiusException, NoSuchAlgorithmException {
        super.setupRequest(c, p);
        this.tunnelRequest = new AccessRequest(this.tunneledAttributes);
        AttributeList attrs = this.tunnelRequest.getAttributes();
        if (attrs.get(1L) == null) {
            attrs.add(AttributeFactory.copyAttribute((RadiusAttribute)this.username, (boolean)false));
        }
        if (attrs.get(2L) == null) {
            attrs.add(AttributeFactory.copyAttribute((RadiusAttribute)this.password, (boolean)false));
        }
        this.tunnelAuth.setupRequest(c, this.tunnelRequest);
        if (!(this.tunnelAuth instanceof PAPAuthenticator)) {
            this.tunnelAuth.processRequest(this.tunnelRequest);
        }
    }

    protected boolean doTunnelAuthentication(byte id, byte[] in) throws RadiusException, SSLException, NoSuchAlgorithmException {
        if (this.tunnelChallenge != null && in != null) {
            AttributeList list = this.tunnelChallenge.getAttributes();
            list.clear();
            ByteBuffer buffer = ByteBuffer.wrap(in);
            diameterFormat.unpackAttributes(list, buffer, buffer.limit(), false);
            if (this.tunnelAuth instanceof EAPAuthenticator && this.tunnelChallenge.findAttribute(79L) == null) {
                this.tunnelAuth.setupRequest(this.client, this.tunnelRequest);
            } else {
                this.tunnelAuth.processChallenge(this.tunnelRequest, this.tunnelChallenge);
            }
        } else {
            this.tunnelChallenge = new AccessChallenge();
        }
        ByteBuffer buffer = ByteBuffer.allocate(1500);
        diameterFormat.packAttributeList(this.tunnelRequest.getAttributes(), buffer, true);
        this.putAppBuffer(buffer.array(), 0, buffer.position());
        RadiusLog.debug((String)("Tunnel Request:\n" + this.tunnelRequest.toString()));
        return true;
    }

    public String getInnerProtocol() {
        return this.innerProtocol;
    }

    public void setInnerProtocol(String innerProtocol) {
        this.innerProtocol = innerProtocol;
    }
}

