/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class Timestamps {
    private static final String TIMESTAMP_FORMAT_PATTERN = "uuuu-MM-dd HH:mm:ss";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("uuuu-MM-dd HH:mm:ss");
    static final long[] POWERS_OF_TEN = new long[]{1L, 10L, 100L, 1000L, 10000L, 100000L, 1000000L, 10000000L, 100000000L, 1000000000L, 10000000000L, 100000000000L, 1000000000000L};
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int MICROSECONDS_PER_MILLISECOND = 1000;
    public static final int MICROSECONDS_PER_SECOND = 1000000;
    public static final long MICROSECONDS_PER_DAY = 86400000000L;
    public static final int NANOSECONDS_PER_MICROSECOND = 1000;
    public static final int NANOSECONDS_PER_MILLISECOND = 1000000;
    public static final long NANOSECONDS_PER_SECOND = 1000000000L;
    public static final long NANOSECONDS_PER_MINUTE = 60000000000L;
    public static final long NANOSECONDS_PER_DAY = 86400000000000L;
    public static final int PICOSECONDS_PER_NANOSECOND = 1000;
    public static final int PICOSECONDS_PER_MICROSECOND = 1000000;
    public static final int PICOSECONDS_PER_MILLISECOND = 1000000000;
    public static final long PICOSECONDS_PER_SECOND = 1000000000000L;
    public static final long PICOSECONDS_PER_MINUTE = 60000000000000L;
    public static final long PICOSECONDS_PER_HOUR = 3600000000000000L;
    public static final long PICOSECONDS_PER_DAY = 86400000000000000L;
    public static final long SECONDS_PER_MINUTE = 60L;
    public static final long MINUTES_PER_HOUR = 60L;
    public static final long SECONDS_PER_DAY = 86400L;

    private Timestamps() {
    }

    public static long round(long value, int magnitude) {
        return Timestamps.roundDiv(value, POWERS_OF_TEN[magnitude]) * POWERS_OF_TEN[magnitude];
    }

    static long rescale(long value, int fromPrecision, int toPrecision) {
        if (value < 0L) {
            throw new IllegalArgumentException("value must be >= 0");
        }
        value = fromPrecision <= toPrecision ? (value *= Timestamps.scaleFactor(fromPrecision, toPrecision)) : (value /= Timestamps.scaleFactor(toPrecision, fromPrecision));
        return value;
    }

    private static long scaleFactor(int fromPrecision, int toPrecision) {
        if (fromPrecision > toPrecision) {
            throw new IllegalArgumentException("fromPrecision must be <= toPrecision");
        }
        return POWERS_OF_TEN[toPrecision - fromPrecision];
    }

    public static int roundDiv(int value, long factor) {
        return (int)Timestamps.roundDiv((long)value, factor);
    }

    public static long roundDiv(long value, long factor) {
        if (factor <= 0L) {
            throw new IllegalArgumentException("Factor must be > 0");
        }
        if (factor == 1L) {
            return value;
        }
        if (value >= 0L) {
            return (value + factor / 2L) / factor;
        }
        return (value + 1L - factor / 2L) / factor;
    }

    public static long truncateEpochMicrosToMillis(long epochMicros) {
        return Math.floorDiv(epochMicros, 1000) * 1000L;
    }

    public static long epochMicrosToMillisWithRounding(long epochMicros) {
        return Timestamps.roundDiv(epochMicros, 1000L);
    }

    static String formatTimestamp(int precision, long epochMicros, int picosOfMicro) {
        Instant instant = Instant.ofEpochSecond(Math.floorDiv(epochMicros, 1000000));
        long picoFraction = (long)Math.floorMod(epochMicros, 1000000) * 1000000L + (long)picosOfMicro;
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, ZoneOffset.UTC);
        StringBuilder builder = new StringBuilder(Timestamps.timestampFormatLength(precision));
        Timestamps.formatTimestamp(precision, dateTime, picoFraction, builder);
        return builder.toString();
    }

    private static int timestampFormatLength(int precision) {
        return TIMESTAMP_FORMAT_PATTERN.length() + (precision == 0 ? 0 : precision + 1);
    }

    static String formatTimestampWithTimeZone(int precision, long epochMillis, int picosOfMilli, ZoneId zoneId) {
        Instant instant = Instant.ofEpochMilli(epochMillis);
        long picoFraction = (long)Math.floorMod(epochMillis, 1000) * 1000000000L + (long)picosOfMilli;
        LocalDateTime dateTime = LocalDateTime.ofInstant(instant, zoneId);
        String zoneIdString = zoneId.getId();
        StringBuilder builder = new StringBuilder(Timestamps.timestampFormatLength(precision) + zoneIdString.length() + 1);
        Timestamps.formatTimestamp(precision, dateTime, picoFraction, builder);
        return builder.append(' ').append(zoneIdString).toString();
    }

    private static void formatTimestamp(int precision, LocalDateTime dateTime, long picoFraction, StringBuilder builder) {
        TIMESTAMP_FORMATTER.formatTo(dateTime, builder);
        if (precision > 0) {
            long scaledFraction = picoFraction / POWERS_OF_TEN[12 - precision];
            builder.append('.');
            builder.setLength(builder.length() + precision);
            int index = builder.length() - 1;
            for (int i = 0; i < precision; ++i) {
                long temp = scaledFraction / 10L;
                int digit = (int)(scaledFraction - temp * 10L);
                scaledFraction = temp;
                builder.setCharAt(index - i, (char)(48 + digit));
            }
        }
    }
}

