/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.connector;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.regex.Pattern;

public final class ConnectorName {
    private static final Pattern VALID_NAME = Pattern.compile("[a-z][a-z0-9_]*");
    private final String name;

    @JsonCreator
    public ConnectorName(String name) {
        if (!VALID_NAME.matcher(name).matches()) {
            throw new IllegalArgumentException("Invalid connector name: " + name);
        }
        this.name = name;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof ConnectorName)) return false;
        ConnectorName other = (ConnectorName)o;
        if (!this.name.equals(other.name)) return false;
        return true;
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

