/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.BlockUtil;
import io.trino.spi.block.RunLengthEncodedBlock;
import io.trino.spi.block.ValueBlock;
import io.trino.spi.block.VariableWidthBlock;
import jakarta.annotation.Nullable;
import java.util.Arrays;
import java.util.Objects;

public class VariableWidthBlockBuilder
implements BlockBuilder {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(VariableWidthBlockBuilder.class);
    private static final Block NULL_VALUE_BLOCK = new VariableWidthBlock(0, 1, Slices.EMPTY_SLICE, new int[]{0, 0}, new boolean[]{true});
    private static final int SIZE_IN_BYTES_PER_POSITION = 5;
    private final BlockBuilderStatus blockBuilderStatus;
    private final int initialEntryCount;
    private final int initialSliceOutputSize;
    private byte[] bytes = new byte[0];
    private boolean hasNullValue;
    private boolean hasNonNullValue;
    private boolean[] valueIsNull = new boolean[0];
    private int[] offsets = new int[1];
    private int positionCount;
    private long arraysRetainedSizeInBytes;

    public VariableWidthBlockBuilder(@Nullable BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytes) {
        this.blockBuilderStatus = blockBuilderStatus;
        this.initialEntryCount = expectedEntries;
        this.initialSliceOutputSize = Math.min(expectedBytes, 0x7FFFFFF5);
        this.updateRetainedSize();
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return (long)this.offsets[this.positionCount] + 5L * (long)this.positionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.arraysRetainedSizeInBytes;
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    public VariableWidthBlockBuilder writeEntry(Slice source) {
        return this.writeEntry(source, 0, source.length());
    }

    public VariableWidthBlockBuilder writeEntry(Slice source, int sourceIndex, int length) {
        this.ensureFreeSpace(length);
        source.getBytes(sourceIndex, this.bytes, this.offsets[this.positionCount], length);
        this.entryAdded(length, false);
        return this;
    }

    public VariableWidthBlockBuilder writeEntry(byte[] source, int sourceIndex, int length) {
        this.ensureFreeSpace(length);
        System.arraycopy(source, sourceIndex, this.bytes, this.offsets[this.positionCount], length);
        this.entryAdded(length, false);
        return this;
    }

    @Override
    public void append(ValueBlock block, int position) {
        this.ensureCapacity(this.positionCount + 1);
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        int bytesWritten = 0;
        if (variableWidthBlock.isNull(position)) {
            this.valueIsNull[this.positionCount] = true;
            this.hasNullValue = true;
        } else {
            int rawArrayBase = variableWidthBlock.getRawArrayBase();
            int[] rawOffsets = variableWidthBlock.getRawOffsets();
            int startValueOffset = rawOffsets[rawArrayBase + position];
            int endValueOffset = rawOffsets[rawArrayBase + position + 1];
            int length = endValueOffset - startValueOffset;
            this.ensureFreeSpace(length);
            Slice rawSlice = variableWidthBlock.getRawSlice();
            byte[] rawByteArray = rawSlice.byteArray();
            int byteArrayOffset = rawSlice.byteArrayOffset();
            System.arraycopy(rawByteArray, byteArrayOffset + startValueOffset, this.bytes, this.offsets[this.positionCount], length);
            bytesWritten = length;
            this.hasNonNullValue = true;
        }
        this.offsets[this.positionCount + 1] = this.offsets[this.positionCount] + bytesWritten;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5 + bytesWritten);
        }
    }

    @Override
    public void appendRepeated(ValueBlock block, int position, int count) {
        if (count == 0) {
            return;
        }
        if (count == 1) {
            this.append(block, position);
            return;
        }
        this.ensureCapacity(this.positionCount + count);
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        int bytesWritten = 0;
        if (variableWidthBlock.isNull(position)) {
            Arrays.fill(this.valueIsNull, this.positionCount, this.positionCount + count, true);
            Arrays.fill(this.offsets, this.positionCount + 1, this.positionCount + count + 1, this.offsets[this.positionCount]);
            this.hasNullValue = true;
        } else {
            int startValueOffset;
            int rawArrayBase = variableWidthBlock.getRawArrayBase();
            int[] rawOffsets = variableWidthBlock.getRawOffsets();
            int endValueOffset = rawOffsets[rawArrayBase + position + 1];
            int length = endValueOffset - (startValueOffset = rawOffsets[rawArrayBase + position]);
            if (length > 0) {
                bytesWritten = Math.toIntExact((long)length * (long)count);
                this.ensureFreeSpace(bytesWritten);
                Slice rawSlice = variableWidthBlock.getRawSlice();
                byte[] rawByteArray = rawSlice.byteArray();
                int byteArrayOffset = rawSlice.byteArrayOffset();
                int currentOffset = this.offsets[this.positionCount];
                System.arraycopy(rawByteArray, byteArrayOffset + startValueOffset, this.bytes, currentOffset, length);
                int duplicatedBytes = length;
                while (duplicatedBytes * 2 <= bytesWritten) {
                    System.arraycopy(this.bytes, currentOffset, this.bytes, currentOffset + duplicatedBytes, duplicatedBytes);
                    duplicatedBytes *= 2;
                }
                System.arraycopy(this.bytes, currentOffset, this.bytes, currentOffset + duplicatedBytes, bytesWritten - duplicatedBytes);
                int previousOffset = currentOffset;
                for (int i = 0; i < count; ++i) {
                    this.offsets[this.positionCount + i + 1] = previousOffset += length;
                }
            } else {
                Arrays.fill(this.offsets, this.positionCount + 1, this.positionCount + count + 1, this.offsets[this.positionCount]);
            }
            this.hasNonNullValue = true;
        }
        this.positionCount += count;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(count * 5 + bytesWritten);
        }
    }

    @Override
    public void appendRange(ValueBlock block, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, offset);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        int rawArrayBase = variableWidthBlock.getRawArrayBase();
        int[] rawOffsets = variableWidthBlock.getRawOffsets();
        int startValueOffset = rawOffsets[rawArrayBase + offset];
        int totalSize = rawOffsets[rawArrayBase + offset + length] - startValueOffset;
        this.ensureFreeSpace(totalSize);
        Slice sourceSlice = variableWidthBlock.getRawSlice();
        System.arraycopy(sourceSlice.byteArray(), sourceSlice.byteArrayOffset() + startValueOffset, this.bytes, this.offsets[this.positionCount], totalSize);
        int offsetDelta = this.offsets[this.positionCount] - rawOffsets[rawArrayBase + offset];
        for (int i = 0; i < length; ++i) {
            this.offsets[this.positionCount + i + 1] = rawOffsets[rawArrayBase + offset + i + 1] + offsetDelta;
        }
        boolean[] rawValueIsNull = variableWidthBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                if (rawValueIsNull[rawArrayBase + offset + i]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.hasNonNullValue = true;
            }
        } else {
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 5);
        }
    }

    @Override
    public void appendPositions(ValueBlock block, int[] positions, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            this.append(block, positions[offset]);
            return;
        }
        this.ensureCapacity(this.positionCount + length);
        VariableWidthBlock variableWidthBlock = (VariableWidthBlock)block;
        int rawArrayBase = variableWidthBlock.getRawArrayBase();
        int[] rawOffsets = variableWidthBlock.getRawOffsets();
        int initialOffset = this.offsets[this.positionCount];
        int totalSize = 0;
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            this.offsets[this.positionCount + i + 1] = initialOffset + (totalSize += rawOffsets[rawArrayBase + position + 1] - rawOffsets[rawArrayBase + position]);
        }
        this.ensureFreeSpace(totalSize);
        Slice rawSlice = variableWidthBlock.getRawSlice();
        byte[] sourceBytes = rawSlice.byteArray();
        int sourceBytesOffset = rawSlice.byteArrayOffset();
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            int sourceStart = rawOffsets[rawArrayBase + position];
            int sourceLength = rawOffsets[rawArrayBase + position + 1] - sourceStart;
            System.arraycopy(sourceBytes, sourceBytesOffset + sourceStart, this.bytes, this.offsets[this.positionCount + i], sourceLength);
            totalSize += sourceLength;
        }
        boolean[] rawValueIsNull = variableWidthBlock.getRawValueIsNull();
        if (rawValueIsNull != null) {
            for (int i = 0; i < length; ++i) {
                int rawPosition = positions[offset + i] + rawArrayBase;
                if (rawValueIsNull[rawPosition]) {
                    this.valueIsNull[this.positionCount + i] = true;
                    this.hasNullValue = true;
                    continue;
                }
                this.hasNonNullValue = true;
            }
        } else {
            this.hasNonNullValue = true;
        }
        this.positionCount += length;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(length * 5 + totalSize);
        }
    }

    @Override
    public BlockBuilder appendNull() {
        this.hasNullValue = true;
        this.entryAdded(0, true);
        return this;
    }

    @Override
    public void resetTo(int position) {
        Objects.checkIndex(position, this.positionCount + 1);
        this.positionCount = position;
    }

    private void entryAdded(int bytesWritten, boolean isNull) {
        this.ensureCapacity(this.positionCount + 1);
        this.valueIsNull[this.positionCount] = isNull;
        this.offsets[this.positionCount + 1] = this.offsets[this.positionCount] + bytesWritten;
        ++this.positionCount;
        this.hasNonNullValue |= !isNull;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5 + bytesWritten);
        }
    }

    @Override
    public Block build() {
        if (!this.hasNonNullValue) {
            return RunLengthEncodedBlock.create(NULL_VALUE_BLOCK, this.positionCount);
        }
        return this.buildValueBlock();
    }

    @Override
    public VariableWidthBlock buildValueBlock() {
        return new VariableWidthBlock(0, this.positionCount, Slices.wrappedBuffer((byte[])this.bytes, (int)0, (int)this.offsets[this.positionCount]), this.offsets, this.hasNullValue ? this.valueIsNull : null);
    }

    @Override
    public BlockBuilder newBlockBuilderLike(int expectedEntries, BlockBuilderStatus blockBuilderStatus) {
        int currentSizeInBytes = this.positionCount == 0 ? this.positionCount : this.getOffset(this.positionCount) - this.getOffset(0);
        return new VariableWidthBlockBuilder(blockBuilderStatus, expectedEntries, BlockUtil.calculateBlockResetBytes(currentSizeInBytes));
    }

    private int getOffset(int position) {
        return this.offsets[position];
    }

    private void ensureCapacity(int capacity) {
        if (this.valueIsNull.length >= capacity) {
            return;
        }
        int newSize = BlockUtil.calculateNewArraySize(capacity, this.initialEntryCount);
        this.valueIsNull = Arrays.copyOf(this.valueIsNull, newSize);
        this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        this.updateRetainedSize();
    }

    private void ensureFreeSpace(int extraBytesCapacity) {
        int requiredSize = this.offsets[this.positionCount] + extraBytesCapacity;
        if (this.bytes.length >= requiredSize) {
            return;
        }
        int newSize = BlockUtil.calculateNewArraySize(requiredSize, this.initialSliceOutputSize);
        this.bytes = Arrays.copyOf(this.bytes, newSize);
        this.updateRetainedSize();
    }

    private void updateRetainedSize() {
        this.arraysRetainedSizeInBytes = SizeOf.sizeOf((boolean[])this.valueIsNull) + SizeOf.sizeOf((int[])this.offsets) + SizeOf.sizeOf((byte[])this.bytes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlockBuilder{");
        sb.append("positionCount=").append(this.positionCount);
        sb.append(", size=").append(this.offsets[this.positionCount]);
        sb.append('}');
        return sb.toString();
    }
}

