/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.type;

import io.trino.spi.block.Block;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.block.BlockBuilderStatus;
import io.trino.spi.block.MapBlock;
import io.trino.spi.block.MapBlockBuilder;
import io.trino.spi.block.SingleMapBlock;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.function.InvocationConvention;
import io.trino.spi.function.OperatorMethodHandle;
import io.trino.spi.type.AbstractType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeOperatorDeclaration;
import io.trino.spi.type.TypeOperators;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.TypeSignatureParameter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

public class MapType
extends AbstractType {
    private static final InvocationConvention EQUAL_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.NEVER_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention HASH_CODE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NEVER_NULL);
    private static final InvocationConvention DISTINCT_FROM_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE, InvocationConvention.InvocationArgumentConvention.BOXED_NULLABLE);
    private static final InvocationConvention INDETERMINATE_CONVENTION = InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.NULL_FLAG);
    private static final MethodHandle EQUAL;
    private static final MethodHandle HASH_CODE;
    private static final MethodHandle SEEK_KEY;
    private static final MethodHandle DISTINCT_FROM;
    private static final MethodHandle INDETERMINATE;
    private final Type keyType;
    private final Type valueType;
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private final MethodHandle keyNativeHashCode;
    private final MethodHandle keyBlockHashCode;
    private final MethodHandle keyBlockNativeEqual;
    private final MethodHandle keyBlockEqual;
    private volatile TypeOperatorDeclaration typeOperatorDeclaration;

    public MapType(Type keyType, Type valueType, TypeOperators typeOperators) {
        super(new TypeSignature("map", TypeSignatureParameter.typeParameter(keyType.getTypeSignature()), TypeSignatureParameter.typeParameter(valueType.getTypeSignature())), Block.class);
        if (!keyType.isComparable()) {
            throw new IllegalArgumentException(String.format("key type must be comparable, got %s", keyType));
        }
        this.keyType = keyType;
        this.valueType = valueType;
        this.keyBlockNativeEqual = typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.NEVER_NULL)).asType(MethodType.methodType(Boolean.class, Block.class, Integer.TYPE, keyType.getJavaType().isPrimitive() ? keyType.getJavaType() : Object.class));
        this.keyBlockEqual = typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        this.keyNativeHashCode = typeOperators.getHashCodeOperator(keyType, HASH_CODE_CONVENTION).asType(MethodType.methodType(Long.TYPE, keyType.getJavaType().isPrimitive() ? keyType.getJavaType() : Object.class));
        this.keyBlockHashCode = typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
    }

    @Override
    public TypeOperatorDeclaration getTypeOperatorDeclaration(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration == null) {
            this.generateTypeOperators(typeOperators);
        }
        return this.typeOperatorDeclaration;
    }

    private synchronized void generateTypeOperators(TypeOperators typeOperators) {
        if (this.typeOperatorDeclaration != null) {
            return;
        }
        if (!this.valueType.isComparable()) {
            this.typeOperatorDeclaration = TypeOperatorDeclaration.NO_TYPE_OPERATOR_DECLARATION;
        }
        this.typeOperatorDeclaration = TypeOperatorDeclaration.builder(this.getJavaType()).addEqualOperator(MapType.getEqualOperatorMethodHandle(typeOperators, this.keyType, this.valueType)).addHashCodeOperator(MapType.getHashCodeOperatorMethodHandle(typeOperators, this.keyType, this.valueType)).addXxHash64Operator(MapType.getXxHash64OperatorMethodHandle(typeOperators, this.keyType, this.valueType)).addDistinctFromOperator(MapType.getDistinctFromOperatorInvoker(typeOperators, this.keyType, this.valueType)).addIndeterminateOperator(MapType.getIndeterminateOperatorInvoker(typeOperators, this.valueType)).build();
    }

    private static OperatorMethodHandle getHashCodeOperatorMethodHandle(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle keyHashCodeOperator = typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        MethodHandle valueHashCodeOperator = typeOperators.getHashCodeOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        return new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(keyHashCodeOperator).bindTo(valueHashCodeOperator));
    }

    private static OperatorMethodHandle getXxHash64OperatorMethodHandle(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle keyHashCodeOperator = typeOperators.getXxHash64Operator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        MethodHandle valueHashCodeOperator = typeOperators.getXxHash64Operator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        return new OperatorMethodHandle(HASH_CODE_CONVENTION, HASH_CODE.bindTo(keyHashCodeOperator).bindTo(valueHashCodeOperator));
    }

    private static OperatorMethodHandle getEqualOperatorMethodHandle(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle seekKey = MethodHandles.insertArguments(SEEK_KEY, 1, typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)), typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)));
        MethodHandle valueEqualOperator = typeOperators.getEqualOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        return new OperatorMethodHandle(EQUAL_CONVENTION, EQUAL.bindTo(seekKey).bindTo(valueEqualOperator));
    }

    private static OperatorMethodHandle getDistinctFromOperatorInvoker(TypeOperators typeOperators, Type keyType, Type valueType) {
        MethodHandle seekKey = MethodHandles.insertArguments(SEEK_KEY, 1, typeOperators.getEqualOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.NULLABLE_RETURN, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)), typeOperators.getHashCodeOperator(keyType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION)));
        MethodHandle valueDistinctFromOperator = typeOperators.getDistinctFromOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        return new OperatorMethodHandle(DISTINCT_FROM_CONVENTION, DISTINCT_FROM.bindTo(seekKey).bindTo(valueDistinctFromOperator));
    }

    private static OperatorMethodHandle getIndeterminateOperatorInvoker(TypeOperators typeOperators, Type valueType) {
        MethodHandle valueIndeterminateOperator = typeOperators.getIndeterminateOperator(valueType, InvocationConvention.simpleConvention(InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, InvocationConvention.InvocationArgumentConvention.BLOCK_POSITION));
        return new OperatorMethodHandle(INDETERMINATE_CONVENTION, INDETERMINATE.bindTo(valueIndeterminateOperator));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new MapBlockBuilder(this, blockBuilderStatus, expectedEntries);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isComparable() {
        return this.valueType.isComparable();
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block singleMapBlock = block.getObject(position, Block.class);
        if (!(singleMapBlock instanceof SingleMapBlock)) {
            throw new UnsupportedOperationException("Map is encoded with legacy block representation");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < singleMapBlock.getPositionCount(); i += 2) {
            map.put(this.keyType.getObjectValue(session, singleMapBlock, i), this.valueType.getObjectValue(session, singleMapBlock, i + 1));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            this.writeObject(blockBuilder, this.getObject(block, position));
        }
    }

    @Override
    public Block getObject(Block block, int position) {
        return block.getObject(position, Block.class);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        if (!(value instanceof SingleMapBlock)) {
            throw new IllegalArgumentException("Maps must be represented with SingleMapBlock");
        }
        SingleMapBlock singleMapBlock = (SingleMapBlock)value;
        BlockBuilder entryBuilder = blockBuilder.beginBlockEntry();
        for (int i = 0; i < singleMapBlock.getPositionCount(); i += 2) {
            this.keyType.appendTo(singleMapBlock, i, entryBuilder);
            this.valueType.appendTo(singleMapBlock, i + 1, entryBuilder);
        }
        blockBuilder.closeEntry();
    }

    @Override
    public List<Type> getTypeParameters() {
        return Arrays.asList(this.getKeyType(), this.getValueType());
    }

    @Override
    public String getDisplayName() {
        return "map(" + this.keyType.getDisplayName() + ", " + this.valueType.getDisplayName() + ")";
    }

    public Block createBlockFromKeyValue(Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock) {
        return MapBlock.fromKeyValueBlock(mapIsNull, offsets, keyBlock, valueBlock, this);
    }

    public MethodHandle getKeyNativeHashCode() {
        return this.keyNativeHashCode;
    }

    public MethodHandle getKeyBlockHashCode() {
        return this.keyBlockHashCode;
    }

    public MethodHandle getKeyBlockNativeEqual() {
        return this.keyBlockNativeEqual;
    }

    public MethodHandle getKeyBlockEqual() {
        return this.keyBlockEqual;
    }

    private static long hashOperator(MethodHandle keyOperator, MethodHandle valueOperator, Block block) throws Throwable {
        long result = 0L;
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            result += MapType.invokeHashOperator(keyOperator, block, i) ^ MapType.invokeHashOperator(valueOperator, block, i + 1);
        }
        return result;
    }

    private static long invokeHashOperator(MethodHandle keyOperator, Block block, int position) throws Throwable {
        if (block.isNull(position)) {
            return 0L;
        }
        return keyOperator.invokeExact(block, position);
    }

    private static Boolean equalOperator(MethodHandle seekKey, MethodHandle valueEqualOperator, Block leftBlock, Block rightBlock) throws Throwable {
        if (leftBlock.getPositionCount() != rightBlock.getPositionCount()) {
            return false;
        }
        SingleMapBlock leftSingleMapLeftBlock = (SingleMapBlock)leftBlock;
        SingleMapBlock rightSingleMapBlock = (SingleMapBlock)rightBlock;
        boolean unknown = false;
        for (int position = 0; position < leftSingleMapLeftBlock.getPositionCount(); position += 2) {
            int leftPosition = position + 1;
            int rightPosition = seekKey.invokeExact(rightSingleMapBlock, leftBlock, position);
            if (rightPosition == -1) {
                return false;
            }
            if (leftBlock.isNull(leftPosition) || rightBlock.isNull(rightPosition)) {
                unknown = true;
                continue;
            }
            Boolean result = valueEqualOperator.invokeExact(leftSingleMapLeftBlock, leftPosition, rightSingleMapBlock, rightPosition);
            if (result == null) {
                unknown = true;
                continue;
            }
            if (result.booleanValue()) continue;
            return false;
        }
        if (unknown) {
            return null;
        }
        return true;
    }

    private static boolean distinctFromOperator(MethodHandle seekKey, MethodHandle valueDistinctFromOperator, Block leftBlock, Block rightBlock) throws Throwable {
        boolean rightIsNull;
        boolean leftIsNull = leftBlock == null;
        boolean bl = rightIsNull = rightBlock == null;
        if (leftIsNull || rightIsNull) {
            return leftIsNull != rightIsNull;
        }
        if (leftBlock.getPositionCount() != rightBlock.getPositionCount()) {
            return true;
        }
        SingleMapBlock leftSingleMapLeftBlock = (SingleMapBlock)leftBlock;
        SingleMapBlock rightSingleMapBlock = (SingleMapBlock)rightBlock;
        for (int position = 0; position < leftSingleMapLeftBlock.getPositionCount(); position += 2) {
            int leftPosition = position + 1;
            int rightPosition = seekKey.invokeExact(rightSingleMapBlock, leftBlock, position);
            if (rightPosition == -1) {
                return true;
            }
            boolean result = valueDistinctFromOperator.invokeExact(leftSingleMapLeftBlock, leftPosition, rightSingleMapBlock, rightPosition);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private static boolean indeterminate(MethodHandle valueIndeterminateFunction, Block block, boolean isNull) throws Throwable {
        if (isNull) {
            return true;
        }
        for (int i = 0; i < block.getPositionCount(); i += 2) {
            if (block.isNull(i + 1)) {
                return true;
            }
            if (!valueIndeterminateFunction.invokeExact(block, i + 1)) continue;
            return true;
        }
        return false;
    }

    static {
        try {
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            EQUAL = lookup.findStatic(MapType.class, "equalOperator", MethodType.methodType(Boolean.class, MethodHandle.class, MethodHandle.class, Block.class, Block.class));
            HASH_CODE = lookup.findStatic(MapType.class, "hashOperator", MethodType.methodType(Long.TYPE, MethodHandle.class, MethodHandle.class, Block.class));
            DISTINCT_FROM = lookup.findStatic(MapType.class, "distinctFromOperator", MethodType.methodType(Boolean.TYPE, MethodHandle.class, MethodHandle.class, Block.class, Block.class));
            INDETERMINATE = lookup.findStatic(MapType.class, "indeterminate", MethodType.methodType(Boolean.TYPE, MethodHandle.class, Block.class, Boolean.TYPE));
            SEEK_KEY = lookup.findVirtual(SingleMapBlock.class, "seekKey", MethodType.methodType(Integer.TYPE, MethodHandle.class, MethodHandle.class, Block.class, Integer.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }
}

