/*
 * Decompiled with CFR 0.152.
 */
package io.trino.spi.block;

import io.trino.spi.block.AbstractSingleRowBlock;
import io.trino.spi.block.Block;
import io.trino.spi.block.BlockUtil;
import java.util.OptionalInt;
import java.util.function.ObjLongConsumer;
import org.openjdk.jol.info.ClassLayout;

public class SingleRowBlock
extends AbstractSingleRowBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleRowBlock.class).instanceSize();
    private final Block[] fieldBlocks;
    private final int rowIndex;

    SingleRowBlock(int rowIndex, Block[] fieldBlocks) {
        this.rowIndex = rowIndex;
        this.fieldBlocks = fieldBlocks;
    }

    int getNumFields() {
        return this.fieldBlocks.length;
    }

    @Override
    Block[] getRawFieldBlocks() {
        return this.fieldBlocks;
    }

    @Override
    protected Block getRawFieldBlock(int fieldIndex) {
        return this.fieldBlocks[fieldIndex];
    }

    @Override
    public int getPositionCount() {
        return this.fieldBlocks.length;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.empty();
    }

    @Override
    public long getSizeInBytes() {
        long sizeInBytes = 0L;
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            sizeInBytes += this.getRawFieldBlock(i).getRegionSizeInBytes(this.getRowIndex(), 1);
        }
        return sizeInBytes;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long retainedSizeInBytes = INSTANCE_SIZE;
        for (int i = 0; i < this.fieldBlocks.length; ++i) {
            retainedSizeInBytes += this.getRawFieldBlock(i).getRetainedSizeInBytes();
        }
        return retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(ObjLongConsumer<Object> consumer) {
        for (Block fieldBlock : this.fieldBlocks) {
            consumer.accept(fieldBlock, fieldBlock.getRetainedSizeInBytes());
        }
        consumer.accept(this, INSTANCE_SIZE);
    }

    @Override
    public String getEncodingName() {
        return "ROW_ELEMENT";
    }

    @Override
    public int getRowIndex() {
        return this.rowIndex;
    }

    public String toString() {
        return String.format("SingleRowBlock{numFields=%d}", this.fieldBlocks.length);
    }

    @Override
    public boolean isLoaded() {
        for (Block fieldBlock : this.fieldBlocks) {
            if (fieldBlock.isLoaded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Block getLoadedBlock() {
        Block[] loadedFieldBlocks = BlockUtil.ensureBlocksAreLoaded(this.fieldBlocks);
        if (loadedFieldBlocks == this.fieldBlocks) {
            return this;
        }
        return new SingleRowBlock(this.getRowIndex(), loadedFieldBlocks);
    }
}

