/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc;

import io.trino.jdbc.$internal.client.ClientTypeSignature;
import io.trino.jdbc.$internal.guava.collect.ImmutableTable;
import io.trino.jdbc.$internal.guava.collect.Table;
import java.sql.SQLException;
import java.util.Objects;

final class TypeConversions {
    private final Table<String, Class<?>, TypeConversion<Object, Object>> conversions;

    private TypeConversions(Table<String, Class<?>, TypeConversion<Object, Object>> conversions) {
        this.conversions = ImmutableTable.copyOf(Objects.requireNonNull(conversions, "conversions is null"));
    }

    public <T> T convert(ClientTypeSignature type, Object value, Class<T> target) throws SQLException {
        if (value == null) {
            return null;
        }
        TypeConversion<Object, Object> conversion = this.conversions.get(type.getRawType(), target);
        if (conversion == null) {
            throw new NoConversionRegisteredException();
        }
        Object converted = conversion.apply(type, value);
        return (T)converted;
    }

    public boolean hasConversion(String sourceRawType, Class<?> target) {
        return this.conversions.contains(sourceRawType, target);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class NoConversionRegisteredException
    extends RuntimeException {
    }

    @FunctionalInterface
    public static interface SimpleTypeConversion<S, T> {
        public T apply(S var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface TypeConversion<S, T> {
        public T apply(ClientTypeSignature var1, S var2) throws SQLException;
    }

    public static class Builder {
        private final ImmutableTable.Builder<String, Class<?>, TypeConversion<Object, Object>> conversions = ImmutableTable.builder();

        private Builder() {
        }

        public <S, T> Builder add(String sourceRawType, Class<S> sourceClass, Class<T> target, SimpleTypeConversion<S, T> conversion) {
            Objects.requireNonNull(conversion, "conversion is null");
            return this.add(sourceRawType, sourceClass, target, (ClientTypeSignature type, S value) -> conversion.apply(value));
        }

        public <S, T> Builder add(String sourceRawType, Class<S> sourceClass, Class<T> target, TypeConversion<S, T> conversion) {
            Objects.requireNonNull(conversion, "conversion is null");
            this.conversions.put(sourceRawType, target, (type, value) -> {
                Object valueAsSourceType = sourceClass.cast(value);
                Object result = conversion.apply(type, valueAsSourceType);
                return target.cast(result);
            });
            return this;
        }

        public TypeConversions build() {
            return new TypeConversions(this.conversions.buildOrThrow());
        }
    }
}

