/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.net.jodah.failsafe;

import io.trino.jdbc.$internal.net.jodah.failsafe.AbstractExecution;
import io.trino.jdbc.$internal.net.jodah.failsafe.ExecutionResult;
import io.trino.jdbc.$internal.net.jodah.failsafe.FailsafeFuture;
import io.trino.jdbc.$internal.net.jodah.failsafe.PolicyExecutor;
import io.trino.jdbc.$internal.net.jodah.failsafe.Timeout;
import io.trino.jdbc.$internal.net.jodah.failsafe.TimeoutExceededException;
import io.trino.jdbc.$internal.net.jodah.failsafe.util.concurrent.Scheduler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

class TimeoutExecutor
extends PolicyExecutor<Timeout> {
    TimeoutExecutor(Timeout timeout, AbstractExecution execution) {
        super(timeout, execution);
    }

    @Override
    protected boolean isFailure(ExecutionResult result) {
        boolean timeoutExceeded = this.execution.isAsyncExecution() && this.execution.getElapsedAttemptTime().toNanos() >= ((Timeout)this.policy).getTimeout().toNanos();
        return timeoutExceeded || !result.isNonResult() && result.getFailure() instanceof TimeoutExceededException;
    }

    @Override
    protected ExecutionResult onFailure(ExecutionResult result) {
        if (!(result.getFailure() instanceof TimeoutExceededException)) {
            result = ExecutionResult.failure(new TimeoutExceededException((Timeout)this.policy));
        }
        return result;
    }

    @Override
    protected Supplier<ExecutionResult> supply(Supplier<ExecutionResult> supplier, Scheduler scheduler) {
        return () -> {
            ScheduledFuture<?> timeoutFuture;
            AtomicReference result = new AtomicReference();
            Thread executionThread = Thread.currentThread();
            try {
                timeoutFuture = scheduler.schedule(() -> {
                    if (result.getAndUpdate(v -> v != null ? v : ExecutionResult.failure(new TimeoutExceededException((Timeout)this.policy))) == null && ((Timeout)this.policy).canCancel()) {
                        this.execution.cancelled = true;
                        if (((Timeout)this.policy).canInterrupt()) {
                            AbstractExecution abstractExecution = this.execution;
                            synchronized (abstractExecution) {
                                if (this.execution.canInterrupt) {
                                    this.execution.record((ExecutionResult)result.get());
                                    this.execution.interrupted = true;
                                    executionThread.interrupt();
                                }
                            }
                        }
                    }
                    return null;
                }, ((Timeout)this.policy).getTimeout().toNanos(), TimeUnit.NANOSECONDS);
            }
            catch (Throwable t) {
                return this.postExecute(ExecutionResult.failure(t));
            }
            if (result.compareAndSet(null, supplier.get())) {
                timeoutFuture.cancel(false);
            }
            return this.postExecute((ExecutionResult)result.get());
        };
    }

    @Override
    protected Supplier<CompletableFuture<ExecutionResult>> supplyAsync(Supplier<CompletableFuture<ExecutionResult>> supplier, Scheduler scheduler, FailsafeFuture<Object> future) {
        return () -> {
            AtomicReference executionResult = new AtomicReference();
            CompletableFuture promise = new CompletableFuture();
            AtomicReference timeoutFuture = new AtomicReference();
            if (!this.execution.isAsyncExecution()) {
                FailsafeFuture failsafeFuture = future;
                synchronized (failsafeFuture) {
                    if (!future.isDone()) {
                        try {
                            timeoutFuture.set(scheduler.schedule(() -> {
                                if (executionResult.compareAndSet(null, ExecutionResult.failure(new TimeoutExceededException((Timeout)this.policy))) && ((Timeout)this.policy).canCancel()) {
                                    boolean canInterrupt = ((Timeout)this.policy).canInterrupt();
                                    if (canInterrupt) {
                                        this.execution.record((ExecutionResult)executionResult.get());
                                    }
                                    future.cancelDelegates(canInterrupt, false);
                                }
                                return null;
                            }, ((Timeout)this.policy).getTimeout().toNanos(), TimeUnit.NANOSECONDS));
                            future.injectTimeout((Future)timeoutFuture.get());
                        }
                        catch (Throwable t) {
                            promise.completeExceptionally(t);
                            return promise;
                        }
                    }
                }
            }
            ((CompletableFuture)supplier.get()).whenComplete((result, error) -> {
                if (executionResult.compareAndSet(null, result)) {
                    if (error != null) {
                        promise.completeExceptionally((Throwable)error);
                        return;
                    }
                    Future maybeFuture = (Future)timeoutFuture.get();
                    if (maybeFuture != null) {
                        maybeFuture.cancel(false);
                    }
                } else {
                    try {
                        result = (ExecutionResult)executionResult.get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                promise.complete(result);
                this.postExecuteAsync((ExecutionResult)result, scheduler, future);
            });
            return promise;
        };
    }
}

