/*
 * Decompiled with CFR 0.152.
 */
package io.trino.jdbc.$internal.client;

import io.trino.jdbc.;
import io.trino.jdbc.$internal.jackson.databind.DeserializationFeature;
import io.trino.jdbc.$internal.jackson.databind.JavaType;
import io.trino.jdbc.$internal.jackson.databind.MapperFeature;
import io.trino.jdbc.$internal.jackson.databind.ObjectMapper;
import io.trino.jdbc.$internal.jackson.datatype.jdk8.Jdk8Module;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.function.Supplier;

public class JsonCodec<T> {
    static final Supplier<ObjectMapper> OBJECT_MAPPER_SUPPLIER = () -> new ObjectMapper().disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES).disable(MapperFeature.AUTO_DETECT_CREATORS).disable(MapperFeature.AUTO_DETECT_FIELDS).disable(MapperFeature.AUTO_DETECT_SETTERS).disable(MapperFeature.AUTO_DETECT_GETTERS).disable(MapperFeature.AUTO_DETECT_IS_GETTERS).disable(MapperFeature.USE_GETTERS_AS_SETTERS).disable(MapperFeature.CAN_OVERRIDE_ACCESS_MODIFIERS).disable(MapperFeature.INFER_PROPERTY_MUTATORS).disable(MapperFeature.ALLOW_FINAL_FIELDS_AS_MUTATORS).registerModule(new Jdk8Module());
    private final ObjectMapper mapper;
    private final Type type;
    private final JavaType javaType;

    public static <T> JsonCodec<T> jsonCodec(Class<T> type) {
        return new JsonCodec<T>(OBJECT_MAPPER_SUPPLIER.get(), type);
    }

    private JsonCodec(ObjectMapper mapper, Type type) {
        this.mapper = Objects.requireNonNull(mapper, "mapper is null");
        this.type = Objects.requireNonNull(type, "type is null");
        this.javaType = mapper.getTypeFactory().constructType(type);
    }

    public Type getType() {
        return this.type;
    }

    public T fromJson(String json) throws .JsonProcessingException {
        return this.mapper.readerFor(this.javaType).readValue(json);
    }
}

