/*
 * Decompiled with CFR 0.152.
 */
package io.takari.builder.internal.digest;

import io.takari.builder.internal.digest.BytesHash;
import io.takari.builder.internal.digest.SHA1Digester;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ClasspathDigester {
    private final ConcurrentMap<String, byte[]> cache;

    public ClasspathDigester(ConcurrentMap<String, byte[]> cache) {
        this.cache = cache;
    }

    public ClasspathDigester() {
        this(new ConcurrentHashMap<String, byte[]>());
    }

    public Serializable digest(List<Path> classpath) throws IOException {
        MessageDigest digester = SHA1Digester.newInstance();
        for (Path file : classpath) {
            String cacheKey = file.toFile().getCanonicalPath().toString();
            byte[] hash = (byte[])this.cache.get(cacheKey);
            if (hash == null) {
                hash = Files.isRegularFile(file, new LinkOption[0]) ? ClasspathDigester.digestZip(file) : (Files.isDirectory(file, new LinkOption[0]) ? ClasspathDigester.digestDir(file) : new byte[]{});
                this.cache.put(cacheKey, hash);
            }
            digester.update(hash);
        }
        return new BytesHash(digester.digest());
    }

    static byte[] digestDir(Path dir) throws IOException {
        MessageDigest digester = SHA1Digester.newInstance();
        TreeSet<Path> sorted = ClasspathDigester.lsLR(dir, new TreeSet<Path>());
        for (Path file : sorted) {
            ClasspathDigester.digestFile(digester, file);
        }
        return digester.digest();
    }

    static byte[] digestZip(Path file) throws IOException {
        MessageDigest digester = SHA1Digester.newInstance();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (ZipFile zip = new ZipFile(file.toFile());){
                TreeSet<ZipEntry> sorted = new TreeSet<ZipEntry>(new Comparator<ZipEntry>(){

                    @Override
                    public int compare(ZipEntry o1, ZipEntry o2) {
                        return o2.getName().compareTo(o1.getName());
                    }
                });
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    sorted.add(entries.nextElement());
                }
                for (ZipEntry entry : sorted) {
                    Throwable throwable2 = null;
                    Object var10_13 = null;
                    try (InputStream is = zip.getInputStream(entry);){
                        ClasspathDigester.digestStream(digester, is);
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            ClasspathDigester.digestFile(digester, file);
        }
        return digester.digest();
    }

    private static TreeSet<Path> lsLR(Path directory, TreeSet<Path> sorted) {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (DirectoryStream<Path> files = Files.newDirectoryStream(directory);){
                for (Path file : files) {
                    if (Files.isDirectory(file, new LinkOption[0])) {
                        ClasspathDigester.lsLR(file, sorted);
                        continue;
                    }
                    sorted.add(file);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return sorted;
        }
        return sorted;
    }

    private static void digestFile(MessageDigest digester, Path file) throws IOException {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            ClasspathDigester.digestStream(digester, is);
        }
    }

    private static void digestStream(MessageDigest digester, InputStream is) throws IOException {
        int r;
        byte[] buf = new byte[4096];
        while ((r = is.read(buf)) > 0) {
            digester.update(buf, 0, r);
        }
    }
}

