/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.typescript;

import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenParameter;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.typescript.AbstractTypeScriptClientCodegen;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.BinarySchema;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.Set;

public class TypeScriptFetchClientCodegen
extends AbstractTypeScriptClientCodegen {
    private static final SimpleDateFormat SNAPSHOT_SUFFIX_FORMAT = new SimpleDateFormat("yyyyMMddHHmm");
    public static final String NPM_NAME = "npmName";
    public static final String NPM_VERSION = "npmVersion";
    public static final String NPM_REPOSITORY = "npmRepository";
    public static final String SNAPSHOT = "snapshot";
    public static final String WITH_INTERFACES = "withInterfaces";
    protected String npmName = null;
    protected String npmVersion = "1.0.0";
    protected String npmRepository = null;

    public TypeScriptFetchClientCodegen() {
        this.outputFolder = "generated-code" + File.separator + "typescript-fetch";
        this.cliOptions.add(new CliOption(NPM_NAME, "The name under which you want to publish generated npm package"));
        this.cliOptions.add(new CliOption(NPM_VERSION, "The version of your npm package"));
        this.cliOptions.add(new CliOption(NPM_REPOSITORY, "Use this property to set an url your private npmRepo in the package.json"));
        this.cliOptions.add(new CliOption(SNAPSHOT, "When setting this property to true the version will be suffixed with -SNAPSHOT.yyyyMMddHHmm", "boolean").defaultValue(Boolean.FALSE.toString()));
        this.cliOptions.add(new CliOption(WITH_INTERFACES, "Setting this property to true will generate interfaces next to the default class implementations.", "boolean").defaultValue(Boolean.FALSE.toString()));
    }

    @Override
    protected void addAdditionPropertiesToCodeGenModel(CodegenModel codegenModel, Schema schema) {
        if (schema instanceof MapSchema && TypeScriptFetchClientCodegen.hasSchemaProperties(schema)) {
            codegenModel.additionalPropertiesType = this.getTypeDeclaration((Schema)schema.getAdditionalProperties());
            this.addImport(codegenModel, codegenModel.additionalPropertiesType);
        } else if (schema instanceof MapSchema && TypeScriptFetchClientCodegen.hasTrueAdditionalProperties(schema)) {
            codegenModel.additionalPropertiesType = this.getTypeDeclaration((Schema)new ObjectSchema());
        }
    }

    public String getName() {
        return "typescript-fetch";
    }

    public String getHelp() {
        return "Generates a TypeScript client library using Fetch API (beta).";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.supportingFiles.add(new SupportingFile("index.mustache", "", "index.ts"));
        this.supportingFiles.add(new SupportingFile("api.mustache", "", "api.ts"));
        this.supportingFiles.add(new SupportingFile("api_test.mustache", "", "api_test.spec.ts"));
        this.supportingFiles.add(new SupportingFile("configuration.mustache", "", "configuration.ts"));
        this.supportingFiles.add(new SupportingFile("custom.d.mustache", "", "custom.d.ts"));
        this.supportingFiles.add(new SupportingFile("git_push.sh.mustache", "", "git_push.sh"));
        this.supportingFiles.add(new SupportingFile("gitignore", "", ".gitignore"));
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.addNpmPackageGeneration();
        }
    }

    @Override
    public String getDefaultTemplateDir() {
        return "typescript-fetch";
    }

    @Override
    public String getTypeDeclaration(Schema propertySchema) {
        if (propertySchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)propertySchema;
            Schema inner = arraySchema.getItems();
            return this.getSchemaType(propertySchema) + "<" + this.getTypeDeclaration(inner) + ">";
        }
        if (propertySchema instanceof MapSchema && TypeScriptFetchClientCodegen.hasSchemaProperties(propertySchema)) {
            Schema inner = (Schema)propertySchema.getAdditionalProperties();
            return "{ [key: string]: " + this.getTypeDeclaration(inner) + "; }";
        }
        if (propertySchema instanceof MapSchema && TypeScriptFetchClientCodegen.hasTrueAdditionalProperties(propertySchema)) {
            ObjectSchema inner = new ObjectSchema();
            return "{ [key: string]: " + this.getTypeDeclaration((Schema)inner) + "; }";
        }
        if (propertySchema instanceof FileSchema || propertySchema instanceof BinarySchema) {
            return "Blob";
        }
        if (propertySchema instanceof ObjectSchema) {
            return "any";
        }
        return super.getTypeDeclaration(propertySchema);
    }

    @Override
    public CodegenParameter fromParameter(Parameter parameter, Set<String> imports) {
        CodegenParameter codegenParameter = super.fromParameter(parameter, imports);
        if (parameter.getSchema() != null && this.isObjectSchema(parameter.getSchema())) {
            codegenParameter.getVendorExtensions().put("x-is-object", Boolean.TRUE);
        }
        return codegenParameter;
    }

    @Override
    public CodegenParameter fromRequestBody(RequestBody body, String name, Schema schema, Map<String, Schema> schemas, Set<String> imports) {
        CodegenParameter codegenParameter = super.fromRequestBody(body, name, schema, schemas, imports);
        if (schema == null) {
            schema = this.getSchemaFromBody(body);
        }
        if (schema != null && this.isObjectSchema(schema)) {
            codegenParameter.getVendorExtensions().put("x-is-object", Boolean.TRUE);
        }
        return codegenParameter;
    }

    @Override
    public String getSchemaType(Schema schema) {
        String swaggerType = super.getSchemaType(schema);
        if (this.isLanguagePrimitive(swaggerType) || this.isLanguageGenericType(swaggerType)) {
            return swaggerType;
        }
        this.applyLocalTypeMapping(swaggerType);
        return swaggerType;
    }

    private String applyLocalTypeMapping(String type) {
        if (this.typeMapping.containsKey(type)) {
            type = (String)this.typeMapping.get(type);
        }
        return type;
    }

    private boolean isLanguagePrimitive(String type) {
        return this.languageSpecificPrimitives.contains(type);
    }

    private boolean isLanguageGenericType(String type) {
        for (String genericType : this.languageGenericTypes) {
            if (!type.startsWith(genericType + "<")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void postProcessParameter(CodegenParameter parameter) {
        String type;
        super.postProcessParameter(parameter);
        parameter.dataType = type = this.applyLocalTypeMapping(parameter.dataType);
        parameter.getVendorExtensions().put("x-is-primitive-type", this.isLanguagePrimitive(type));
    }

    private void addNpmPackageGeneration() {
        if (this.additionalProperties.containsKey(NPM_NAME)) {
            this.setNpmName(this.additionalProperties.get(NPM_NAME).toString());
        }
        if (this.additionalProperties.containsKey(NPM_VERSION)) {
            this.setNpmVersion(this.additionalProperties.get(NPM_VERSION).toString());
        }
        if (this.additionalProperties.containsKey(SNAPSHOT) && Boolean.valueOf(this.additionalProperties.get(SNAPSHOT).toString()).booleanValue()) {
            this.setNpmVersion(this.npmVersion + "-SNAPSHOT." + SNAPSHOT_SUFFIX_FORMAT.format(new Date()));
        }
        this.additionalProperties.put(NPM_VERSION, this.npmVersion);
        if (this.additionalProperties.containsKey(NPM_REPOSITORY)) {
            this.setNpmRepository(this.additionalProperties.get(NPM_REPOSITORY).toString());
        }
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("package.mustache", "", "package.json"));
        this.supportingFiles.add(new SupportingFile("tsconfig.mustache", "", "tsconfig.json"));
    }

    public String getNpmName() {
        return this.npmName;
    }

    public void setNpmName(String npmName) {
        this.npmName = npmName;
    }

    public String getNpmVersion() {
        return this.npmVersion;
    }

    public void setNpmVersion(String npmVersion) {
        this.npmVersion = npmVersion;
    }

    public String getNpmRepository() {
        return this.npmRepository;
    }

    public void setNpmRepository(String npmRepository) {
        this.npmRepository = npmRepository;
    }
}

