/*
 * Decompiled with CFR 0.152.
 */
package io.socket.socketio.server;

import io.socket.engineio.server.ReadyState;
import io.socket.socketio.server.PacketUtils;
import io.socket.socketio.server.SocketIoClient;
import io.socket.socketio.server.SocketIoNamespace;
import io.socket.socketio.server.SocketIoServer;
import io.socket.socketio.server.SocketIoSocket;
import io.socket.socketio.server.parser.Packet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

final class SocketIoNamespaceImpl
extends SocketIoNamespace {
    private final Map<String, SocketIoSocket> mSockets = new ConcurrentHashMap<String, SocketIoSocket>();
    private final Map<String, SocketIoSocket> mConnectedSockets = new ConcurrentHashMap<String, SocketIoSocket>();
    private final AtomicInteger mAckId = new AtomicInteger(0);

    SocketIoNamespaceImpl(SocketIoServer server, String name) {
        super(server, name);
    }

    @Override
    public void broadcast(String[] rooms, String event, Object[] args) throws IllegalArgumentException {
        if (event == null) {
            throw new IllegalArgumentException("event cannot be null.");
        }
        Packet<?> packet = PacketUtils.createDataPacket(2, event, args);
        this.mAdapter.broadcast(packet, rooms);
    }

    @Override
    Map<String, SocketIoSocket> getConnectedSockets() {
        return this.mConnectedSockets;
    }

    int nextId() {
        return this.mAckId.incrementAndGet();
    }

    synchronized SocketIoSocket add(SocketIoClient client, Object data) {
        SocketIoSocket socket = new SocketIoSocket(this, client, data);
        if (client.getConnection().getReadyState() == ReadyState.OPEN) {
            this.mSockets.put(socket.getId(), socket);
            socket.onConnect();
            this.emit("connect", new Object[]{socket});
            this.emit("connection", new Object[]{socket});
        }
        return socket;
    }

    synchronized void remove(SocketIoSocket socket) {
        this.mSockets.remove(socket.getId());
    }

    synchronized void addConnected(SocketIoSocket socket) {
        this.mConnectedSockets.put(socket.getId(), socket);
    }

    synchronized void removeConnected(SocketIoSocket socket) {
        this.mConnectedSockets.remove(socket.getId());
    }
}

