/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.transport.netty.server;

import io.rsocket.Closeable;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Objects;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableChannel;

public final class CloseableChannel
implements Closeable {
    private static final Method channelAddressMethod;
    private final DisposableChannel channel;

    CloseableChannel(DisposableChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel must not be null");
    }

    public InetSocketAddress address() {
        try {
            return (InetSocketAddress)this.channel.address();
        }
        catch (ClassCastException | NoSuchMethodError e) {
            try {
                return (InetSocketAddress)channelAddressMethod.invoke((Object)this.channel, new Object[0]);
            }
            catch (Exception ex) {
                throw new IllegalStateException("Unable to obtain address", ex);
            }
        }
    }

    public void dispose() {
        this.channel.dispose();
    }

    public boolean isDisposed() {
        return this.channel.isDisposed();
    }

    public Mono<Void> onClose() {
        return this.channel.onDispose();
    }

    static {
        try {
            channelAddressMethod = DisposableChannel.class.getMethod("address", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Expected address method", ex);
        }
    }
}

