/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.Proto;
import io.riemann.riemann.client.SynchronousTransport;
import io.riemann.riemann.client.Transport;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class SimpleUdpTransport
implements SynchronousTransport {
    public static final int DEFAULT_PORT = 5555;
    private volatile DatagramSocket socket;
    private volatile boolean connected = false;
    private final InetSocketAddress remoteAddress;
    private final InetSocketAddress localAddress;

    public SimpleUdpTransport(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = null;
    }

    public SimpleUdpTransport(InetSocketAddress remoteAddress, InetSocketAddress localAddress) {
        this.remoteAddress = remoteAddress;
        this.localAddress = localAddress;
    }

    public SimpleUdpTransport(String host, int port) throws IOException {
        this(InetSocketAddress.createUnresolved(host, port));
    }

    public SimpleUdpTransport(String remoteHost, int remotePort, String localHost, int localPort) throws IOException {
        this(InetSocketAddress.createUnresolved(remoteHost, remotePort), InetSocketAddress.createUnresolved(localHost, localPort));
    }

    public SimpleUdpTransport(String host) throws IOException {
        this(host, 5555);
    }

    public SimpleUdpTransport(String remoteHost, String localHost) throws IOException {
        this(remoteHost, 5555, localHost, 0);
    }

    public SimpleUdpTransport(int port) throws IOException {
        this(InetAddress.getLocalHost().getHostAddress(), port);
    }

    @Override
    public Proto.Msg sendMessage(Proto.Msg msg) throws IOException {
        byte[] body = msg.toByteArray();
        DatagramPacket packet = new DatagramPacket(body, body.length, SimpleUdpTransport.ensureResolved(this.remoteAddress));
        this.socket.send(packet);
        return null;
    }

    @Override
    public boolean isConnected() {
        return this.connected;
    }

    @Override
    public synchronized void connect() throws IOException {
        this.socket = this.localAddress != null ? new DatagramSocket(SimpleUdpTransport.ensureResolved(this.localAddress)) : new DatagramSocket();
        this.connected = true;
    }

    @Override
    public synchronized void close() {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
            this.connected = false;
        }
    }

    @Override
    public void reconnect() throws IOException {
        this.close();
        this.connect();
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public Transport transport() {
        return null;
    }

    private static InetSocketAddress ensureResolved(InetSocketAddress maybeUnresolved) throws UnknownHostException {
        if (maybeUnresolved.isUnresolved()) {
            return new InetSocketAddress(InetAddress.getByName(maybeUnresolved.getHostName()), maybeUnresolved.getPort());
        }
        return maybeUnresolved;
    }
}

