/*
 * Decompiled with CFR 0.152.
 */
package io.riemann.riemann.client;

import io.riemann.riemann.Proto;
import io.riemann.riemann.client.AsynchronousTransport;
import io.riemann.riemann.client.Promise;
import io.riemann.riemann.client.SynchronousTransport;
import java.io.IOException;

public class AsynchronizeTransport
implements AsynchronousTransport {
    public final SynchronousTransport transport;

    public AsynchronizeTransport(SynchronousTransport transport) {
        this.transport = transport;
    }

    public Promise<Proto.Msg> sendMessage(Proto.Msg msg) {
        Promise<Proto.Msg> p = new Promise<Proto.Msg>();
        try {
            Proto.Msg response = this.transport.sendMessage(msg);
            if (response == null) {
                p.deliver(new UnsupportedOperationException(this.transport.toString() + " doesn't support receiving messages."));
            } else {
                p.deliver(response);
            }
        }
        catch (IOException e) {
            p.deliver(e);
        }
        catch (RuntimeException e) {
            p.deliver(e);
        }
        return p;
    }

    @Override
    public SynchronousTransport transport() {
        return this.transport;
    }

    @Override
    public boolean isConnected() {
        return this.transport.isConnected();
    }

    @Override
    public void connect() throws IOException {
        this.transport.connect();
    }

    @Override
    public void close() {
        this.transport.close();
    }

    @Override
    public void reconnect() throws IOException {
        this.transport.reconnect();
    }

    @Override
    public void flush() throws IOException {
        this.transport.flush();
    }
}

