/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.hibernate.orm.runtime.tenant;

import io.agroal.api.AgroalDataSource;
import io.agroal.api.AgroalDataSourceListener;
import io.agroal.api.configuration.AgroalDataSourceConfiguration;
import io.quarkus.agroal.DataSource;
import io.quarkus.arc.Arc;
import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.hibernate.orm.runtime.customized.QuarkusConnectionProvider;
import io.quarkus.hibernate.orm.runtime.migration.MultiTenancyStrategy;
import io.quarkus.hibernate.orm.runtime.tenant.TenantConnectionResolver;
import jakarta.enterprise.inject.Default;
import java.lang.annotation.Annotation;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Optional;
import org.hibernate.engine.jdbc.connections.spi.ConnectionProvider;
import org.jboss.logging.Logger;

public class DataSourceTenantConnectionResolver
implements TenantConnectionResolver {
    private static final Logger LOG = Logger.getLogger(DataSourceTenantConnectionResolver.class);
    private String persistenceUnitName;
    private Optional<String> dataSourceName;
    private MultiTenancyStrategy multiTenancyStrategy;
    private String multiTenancySchemaDataSourceName;

    public DataSourceTenantConnectionResolver() {
    }

    public DataSourceTenantConnectionResolver(String persistenceUnitName, Optional<String> dataSourceName, MultiTenancyStrategy multiTenancyStrategy, String multiTenancySchemaDataSourceName) {
        this.persistenceUnitName = persistenceUnitName;
        this.dataSourceName = dataSourceName;
        this.multiTenancyStrategy = multiTenancyStrategy;
        this.multiTenancySchemaDataSourceName = multiTenancySchemaDataSourceName;
    }

    @Override
    public ConnectionProvider resolve(String tenantId) {
        LOG.debugv("resolve((persistenceUnitName={0}, tenantIdentifier={1})", (Object)this.persistenceUnitName, (Object)tenantId);
        LOG.debugv("multitenancy strategy: {0}", (Object)this.multiTenancyStrategy);
        AgroalDataSource dataSource = DataSourceTenantConnectionResolver.tenantDataSource(this.dataSourceName, tenantId, this.multiTenancyStrategy, this.multiTenancySchemaDataSourceName);
        if (dataSource == null) {
            throw new IllegalStateException(String.format(Locale.ROOT, "No instance of datasource found for persistence unit '%1$s' and tenant '%2$s'", this.persistenceUnitName, tenantId));
        }
        if (this.multiTenancyStrategy == MultiTenancyStrategy.SCHEMA) {
            return new SchemaTenantConnectionProvider(tenantId, dataSource);
        }
        return new QuarkusConnectionProvider(dataSource);
    }

    private static AgroalDataSource createFrom(AgroalDataSourceConfiguration config) {
        try {
            return AgroalDataSource.from((AgroalDataSourceConfiguration)config, (AgroalDataSourceListener[])new AgroalDataSourceListener[0]);
        }
        catch (SQLException ex) {
            throw new IllegalStateException("Failed to create a new data source based on the existing datasource configuration", ex);
        }
    }

    private static AgroalDataSource tenantDataSource(Optional<String> dataSourceName, String tenantId, MultiTenancyStrategy strategy, String multiTenancySchemaDataSourceName) {
        if (strategy != MultiTenancyStrategy.SCHEMA) {
            return (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(tenantId)}).get();
        }
        if (multiTenancySchemaDataSourceName == null) {
            AgroalDataSource dataSource = DataSourceTenantConnectionResolver.getDataSource(dataSourceName.get());
            return DataSourceTenantConnectionResolver.createFrom(dataSource.getConfiguration());
        }
        return DataSourceTenantConnectionResolver.getDataSource(multiTenancySchemaDataSourceName);
    }

    private static AgroalDataSource getDataSource(String dataSourceName) {
        if (DataSourceUtil.isDefault((String)dataSourceName)) {
            return (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{Default.Literal.INSTANCE}).get();
        }
        return (AgroalDataSource)Arc.container().instance(AgroalDataSource.class, new Annotation[]{new DataSource.DataSourceLiteral(dataSourceName)}).get();
    }

    private static class SchemaTenantConnectionProvider
    extends QuarkusConnectionProvider {
        private final String tenantId;

        public SchemaTenantConnectionProvider(String tenantId, AgroalDataSource dataSource) {
            super(dataSource);
            this.tenantId = tenantId;
        }

        @Override
        public Connection getConnection() throws SQLException {
            Connection conn = super.getConnection();
            conn.setSchema(this.tenantId);
            LOG.debugv("Set tenant {0} for connection: {1}", (Object)this.tenantId, (Object)conn);
            return conn;
        }
    }
}

