/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.UpdateProjectCommandHandler;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import io.quarkus.registry.catalog.ExtensionCatalog;
import java.util.HashMap;
import java.util.Objects;

public class UpdateProject {
    public static final String APP_MODEL = "quarkus.update-project.app-model";
    public static final String TARGET_CATALOG = "quarkus.update-project.target-catalog";
    public static final String PER_MODULE = "quarkus.update-project.per-module";
    public static final String NO_REWRITE = "quarkus.update-project.rewrite.disabled";
    public static final String TARGET_PLATFORM_VERSION = "quarkus.update-project.target-platform-version";
    public static final String REWRITE_PLUGIN_VERSION = "quarkus.update-project.rewrite.plugin-version";
    public static final String REWRITE_UPDATE_RECIPES_VERSION = "quarkus.update-project.rewrite.update-recipes-version";
    public static final String REWRITE_DRY_RUN = "quarkus.update-project.rewrite.dry-run";
    private final QuarkusCommandInvocation invocation;
    private final UpdateProjectCommandHandler handler = new UpdateProjectCommandHandler();

    public UpdateProject(QuarkusProject quarkusProject) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject);
    }

    public UpdateProject(QuarkusProject quarkusProject, MessageWriter messageWriter) {
        this.invocation = new QuarkusCommandInvocation(quarkusProject, new HashMap<String, Object>(), messageWriter);
    }

    public UpdateProject targetCatalog(ExtensionCatalog latestCatalog) {
        this.invocation.setValue(TARGET_CATALOG, Objects.requireNonNull(latestCatalog, "targetCatalog is required"));
        return this;
    }

    public UpdateProject appModel(ApplicationModel applicationModel) {
        this.invocation.setValue(APP_MODEL, Objects.requireNonNull(applicationModel, "applicationModel is required"));
        return this;
    }

    public UpdateProject noRewrite(boolean noRewrite) {
        this.invocation.setValue(NO_REWRITE, noRewrite);
        return this;
    }

    public UpdateProject rewritePluginVersion(String rewritePluginVersion) {
        this.invocation.setValue(REWRITE_PLUGIN_VERSION, Objects.requireNonNull(rewritePluginVersion, "rewritePluginVersion is required"));
        return this;
    }

    public UpdateProject rewriteUpdateRecipesVersion(String rewriteUpdateRecipesVersion) {
        this.invocation.setValue(REWRITE_UPDATE_RECIPES_VERSION, Objects.requireNonNull(rewriteUpdateRecipesVersion, "rewriteUpdateRecipesVersion is required"));
        return this;
    }

    public UpdateProject rewriteDryRun(boolean rewriteDryRun) {
        this.invocation.setValue(REWRITE_DRY_RUN, rewriteDryRun);
        return this;
    }

    public UpdateProject perModule(boolean perModule) {
        this.invocation.setValue(PER_MODULE, perModule);
        return this;
    }

    public UpdateProject targetPlatformVersion(String targetPlatformVersion) {
        this.invocation.setValue(TARGET_PLATFORM_VERSION, targetPlatformVersion);
        return this;
    }

    public QuarkusCommandOutcome execute() throws QuarkusCommandException {
        return this.handler.execute(this.invocation);
    }
}

