/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cli.plugin;

import io.quarkus.cli.plugin.Plugin;
import io.quarkus.cli.plugin.PluginCatalog;
import io.quarkus.cli.plugin.PluginCatalogService;
import io.quarkus.cli.plugin.PluginManagerSettings;
import io.quarkus.cli.plugin.PluginManagerUtil;
import io.quarkus.cli.plugin.PluginMangerState;
import io.quarkus.cli.plugin.PluginType;
import io.quarkus.cli.plugin.PluginUtil;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.QuarkusProject;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class PluginManager {
    private static PluginManager INSTANCE;
    private final MessageWriter output;
    private final PluginMangerState state;
    private final PluginManagerSettings settings;
    private final PluginManagerUtil util;

    public static synchronized PluginManager get() {
        if (INSTANCE == null) {
            throw new IllegalStateException("No instance of PluginManager found");
        }
        return INSTANCE;
    }

    public static synchronized PluginManager create(PluginManagerSettings settings, MessageWriter output, Optional<Path> userHome, Optional<Path> currentDir, Supplier<QuarkusProject> quarkusProject) {
        if (INSTANCE == null) {
            INSTANCE = new PluginManager(settings, output, userHome, currentDir, quarkusProject);
        }
        return INSTANCE;
    }

    PluginManager(PluginManagerSettings settings, MessageWriter output, Optional<Path> userHome, Optional<Path> currentDir, Supplier<QuarkusProject> quarkusProject) {
        this.settings = settings;
        this.output = output;
        this.util = PluginManagerUtil.getUtil(settings);
        this.state = new PluginMangerState(settings, output, userHome, currentDir, quarkusProject);
    }

    public Optional<Plugin> addPlugin(String nameOrLocation) {
        return this.addPlugin(nameOrLocation, false, Optional.empty());
    }

    public Optional<Plugin> addPlugin(String nameOrLocation, boolean userCatalog, Optional<String> description) {
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        String name = this.util.getName(nameOrLocation);
        Optional<Object> location = Optional.empty();
        if (PluginUtil.isRemoteLocation(nameOrLocation)) {
            location = Optional.of(nameOrLocation);
        } else if (PluginUtil.isLocalFile(nameOrLocation)) {
            Optional<Path> projectRelative = this.state.getProjectRoot().filter(r -> !userCatalog).filter(r -> PluginUtil.isProjectFile(r, nameOrLocation)).map(r -> r.relativize(Path.of(nameOrLocation, new String[0]).toAbsolutePath()));
            location = projectRelative.or(() -> Optional.of(nameOrLocation).map(x$0 -> Path.of(x$0, new String[0])).map(Path::toAbsolutePath)).map(Path::toString);
        }
        if (!location.isEmpty()) {
            Plugin plugin = new Plugin(name, PluginUtil.getType(nameOrLocation), location, description, Optional.empty(), userCatalog || this.state.getProjectCatalog().isEmpty());
            PluginCatalog updatedCatalog = this.state.pluginCatalog(userCatalog).addPlugin(plugin);
            pluginCatalogService.writeCatalog(updatedCatalog);
            this.state.invalidateInstalledPlugins();
            return Optional.of(plugin);
        }
        Map<String, Plugin> installablePlugins = this.state.installablePlugins();
        Optional<Plugin> plugin = Optional.ofNullable(installablePlugins.get(name)).map(Plugin::inUserCatalog);
        return plugin.map(p -> {
            Plugin withDescription = p.withDescription(description);
            PluginCatalog updatedCatalog = this.state.pluginCatalog(userCatalog).addPlugin(withDescription);
            pluginCatalogService.writeCatalog(updatedCatalog);
            this.state.invalidateInstalledPlugins();
            return withDescription;
        });
    }

    public Optional<Plugin> addPlugin(Plugin plugin) {
        return this.addPlugin(plugin, false);
    }

    public Optional<Plugin> addPlugin(Plugin plugin, boolean userCatalog) {
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        PluginCatalog updatedCatalog = this.state.pluginCatalog(userCatalog).addPlugin(plugin);
        pluginCatalogService.writeCatalog(updatedCatalog);
        this.state.invalidateInstalledPlugins();
        return Optional.of(plugin);
    }

    public Optional<Plugin> removePlugin(String name) {
        return this.removePlugin(name, false);
    }

    public Optional<Plugin> removePlugin(String name, boolean userCatalog) {
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        Plugin plugin = this.state.getInstalledPluigns().get(name);
        if (plugin == null) {
            return Optional.empty();
        }
        if (userCatalog) {
            Optional<Plugin> userPlugin = this.state.getUserCatalog().map(PluginCatalog::getPlugins).map(p -> (Plugin)p.get(name));
            return userPlugin.map(p -> {
                pluginCatalogService.writeCatalog(this.state.getUserCatalog().orElseThrow(() -> new IllegalStateException("User catalog should be available")).removePlugin((Plugin)p));
                this.state.invalidateInstalledPlugins();
                return p;
            });
        }
        if (plugin.isInUserCatalog()) {
            pluginCatalogService.writeCatalog(this.state.getUserCatalog().orElseThrow(() -> new IllegalStateException("User catalog should be available")).removePlugin(plugin));
        } else {
            pluginCatalogService.writeCatalog(this.state.getProjectCatalog().orElseThrow(() -> new IllegalStateException("Project catalog should be available")).removePlugin(plugin));
        }
        this.state.invalidateInstalledPlugins();
        return Optional.of(plugin);
    }

    public Optional<Plugin> removePlugin(Plugin plugin) {
        return this.removePlugin(plugin, false);
    }

    public Optional<Plugin> removePlugin(Plugin plugin, boolean userCatalog) {
        return this.removePlugin(plugin.getName(), userCatalog);
    }

    public boolean reconcile() {
        if (this.state.getUserCatalog().map(c -> this.reconcile((PluginCatalog)c)).orElse(false) | this.state.getProjectCatalog().map(c -> this.reconcile((PluginCatalog)c)).orElse(false)) {
            this.state.invalidate();
            return true;
        }
        return false;
    }

    private boolean reconcile(PluginCatalog catalog) {
        Path location = catalog.getCatalogLocation().orElseThrow(() -> new IllegalArgumentException("Unknwon plugin catalog location."));
        List<PluginType> installedTypes = catalog.getPlugins().entrySet().stream().map(Map.Entry::getValue).map(Plugin::getType).collect(Collectors.toList());
        Map<String, Plugin> installablePlugins = this.state.installablePlugins(installedTypes).entrySet().stream().filter(e -> installedTypes.contains((Object)((Plugin)e.getValue()).getType())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Plugin)e.getValue()));
        Map<String, Plugin> unreachable = catalog.getPlugins().entrySet().stream().filter(i -> !installablePlugins.containsKey(i.getKey())).filter(i -> PluginUtil.shouldRemove((Plugin)i.getValue())).collect(Collectors.toMap(m -> (String)m.getKey(), m -> (Plugin)m.getValue()));
        if (unreachable.isEmpty()) {
            return false;
        }
        Path backupLocation = location.getParent().resolve("quarkus-cli-catalog.json.bkp");
        this.output.warn("The following plugins were found in the catalog: [%s] but are no longer available: %s.\nThe unavailable plugins will be purged. A backup of the catalog will be saved at: [%s].", new Object[]{location, unreachable.entrySet().stream().map(Map.Entry::getKey).collect(Collectors.joining(", ", "[", "]")), backupLocation});
        PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
        pluginCatalogService.writeCatalog(catalog.withCatalogLocation((Optional)Optional.of(backupLocation)));
        for (String u : unreachable.keySet()) {
            catalog = catalog.removePlugin(u);
        }
        pluginCatalogService.writeCatalog(catalog);
        return true;
    }

    public boolean sync() {
        boolean catalogModified = this.reconcile();
        Map<String, Plugin> installedPlugins = this.getInstalledPlugins();
        Map<String, Plugin> extensionPlugins = this.state.getExtensionPlugins();
        Map<String, Plugin> pluginsToInstall = extensionPlugins.entrySet().stream().filter(e -> !installedPlugins.containsKey(e.getKey())).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (Plugin)e.getValue()));
        catalogModified = catalogModified || !pluginsToInstall.isEmpty();
        pluginsToInstall.forEach((name, plugin) -> this.addPlugin((Plugin)plugin));
        this.state.invalidate();
        if (!catalogModified) {
            PluginCatalogService pluginCatalogService = this.state.getPluginCatalogService();
            PluginCatalog catalog = this.state.pluginCatalog(false);
            pluginCatalogService.writeCatalog(catalog);
        }
        return catalogModified;
    }

    public boolean syncIfNeeded() {
        if (!this.settings.isInteractiveMode()) {
            return false;
        }
        boolean createdMissingProjectCatalog = this.state.getPluginCatalogService().findProjectCatalogPath(this.state.getProjectRoot()).map(Path::toFile).filter(Predicate.not(File::exists)).map(File::toPath).map(p -> {
            this.output.debug("Project plugin catalog has not been initialized. Initializing.");
            this.state.getPluginCatalogService().writeCatalog((PluginCatalog)new PluginCatalog().withCatalogLocation((Path)p));
            return true;
        }).orElse(false);
        if (createdMissingProjectCatalog) {
            return this.sync();
        }
        PluginCatalog catalog = this.state.getCombinedCatalog();
        if (PluginUtil.shouldSync(this.state.getProjectRoot(), catalog)) {
            this.output.debug("Plugin catalog last updated on: " + catalog.getLastUpdate() + ". Syncing.");
            return this.sync();
        }
        return false;
    }

    public Map<String, Plugin> getInstalledPlugins(boolean userCatalog) {
        return userCatalog ? this.state.userPlugins() : this.state.getInstalledPluigns();
    }

    public Map<String, Plugin> getInstalledPlugins() {
        return this.getInstalledPlugins(false);
    }

    public Map<String, Plugin> getInstallablePlugins() {
        return this.state.getInstallablePlugins();
    }

    public PluginManagerUtil getUtil() {
        return this.util;
    }
}

