/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.jdk.internal;

import java.net.http.HttpRequest;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Flow;
import java.util.function.Supplier;

final class BodyPublisher
implements HttpRequest.BodyPublisher {
    private final int length;
    private final byte[] content;
    private final Supplier<ByteBuffer> bufSupplier;

    BodyPublisher(byte[] content, int length, Supplier<ByteBuffer> bufSupplier) {
        this.content = content;
        this.length = length;
        this.bufSupplier = bufSupplier;
    }

    private List<ByteBuffer> copyToBuffers() {
        int lengthToCopy;
        int offset = 0;
        ArrayList<ByteBuffer> buffers = new ArrayList<ByteBuffer>();
        for (int length = this.length; length > 0; length -= lengthToCopy) {
            ByteBuffer b = this.bufSupplier.get();
            b.clear();
            lengthToCopy = Math.min(b.capacity(), length);
            b.put(this.content, offset, lengthToCopy);
            offset += lengthToCopy;
            b.flip();
            buffers.add(b);
        }
        return buffers;
    }

    @Override
    public long contentLength() {
        return this.length;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        Subscription subscription = new Subscription(this.copyToBuffers(), subscriber);
        subscriber.onSubscribe(subscription);
    }

    private static class Subscription
    implements Flow.Subscription {
        private volatile boolean isCompleted;
        private final List<ByteBuffer> buffers;
        private final Flow.Subscriber<? super ByteBuffer> subscriber;
        private int offset = 0;

        private Subscription(List<ByteBuffer> buffers, Flow.Subscriber<? super ByteBuffer> subscriber) {
            this.buffers = buffers;
            this.subscriber = subscriber;
        }

        @Override
        public void request(long n) {
            if (this.isCompleted) {
                return;
            }
            if (n <= 0L) {
                this.subscriber.onError(new IllegalArgumentException("Subscription request must be >= 0"));
                this.isCompleted = true;
            } else {
                this.run(n);
            }
        }

        @Override
        public void cancel() {
            this.isCompleted = true;
        }

        private synchronized void run(long requestedItems) {
            if (this.isCompleted) {
                return;
            }
            for (long count = 0L; count < requestedItems; ++count) {
                int nextIndex;
                ++this.offset;
                if (nextIndex >= this.buffers.size()) break;
                ByteBuffer next = this.buffers.get(nextIndex);
                this.subscriber.onNext(next);
            }
            if (this.offset >= this.buffers.size()) {
                this.isCompleted = true;
                this.subscriber.onComplete();
            }
        }
    }
}

