/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.jackson.datatype.jdk8;

import io.opentelemetry.testing.internal.jackson.core.JsonGenerator;
import io.opentelemetry.testing.internal.jackson.core.JsonParser;
import io.opentelemetry.testing.internal.jackson.databind.JavaType;
import io.opentelemetry.testing.internal.jackson.databind.JsonMappingException;
import io.opentelemetry.testing.internal.jackson.databind.SerializerProvider;
import io.opentelemetry.testing.internal.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import io.opentelemetry.testing.internal.jackson.databind.jsonFormatVisitors.JsonIntegerFormatVisitor;
import io.opentelemetry.testing.internal.jackson.databind.ser.std.StdScalarSerializer;
import java.io.IOException;
import java.util.OptionalLong;

final class OptionalLongSerializer
extends StdScalarSerializer<OptionalLong> {
    private static final long serialVersionUID = 1L;
    static final OptionalLongSerializer INSTANCE = new OptionalLongSerializer();

    public OptionalLongSerializer() {
        super(OptionalLong.class);
    }

    @Override
    public boolean isEmpty(SerializerProvider provider, OptionalLong value) {
        return value == null || !value.isPresent();
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        JsonIntegerFormatVisitor v2 = visitor.expectIntegerFormat(typeHint);
        if (v2 != null) {
            v2.numberType(JsonParser.NumberType.LONG);
        }
    }

    @Override
    public void serialize(OptionalLong value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value.isPresent()) {
            jgen.writeNumber(value.getAsLong());
        } else {
            jgen.writeNull();
        }
    }
}

