/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.netty.handler.address;

import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandler;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelOutboundHandlerAdapter;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelPromise;
import io.opentelemetry.testing.internal.io.netty.resolver.AddressResolver;
import io.opentelemetry.testing.internal.io.netty.resolver.AddressResolverGroup;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.Future;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.FutureListener;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.GenericFutureListener;
import io.opentelemetry.testing.internal.io.netty.util.internal.ObjectUtil;
import java.net.SocketAddress;

@ChannelHandler.Sharable
public class ResolveAddressHandler
extends ChannelOutboundHandlerAdapter {
    private final AddressResolverGroup<? extends SocketAddress> resolverGroup;

    public ResolveAddressHandler(AddressResolverGroup<? extends SocketAddress> resolverGroup) {
        this.resolverGroup = ObjectUtil.checkNotNull(resolverGroup, "resolverGroup");
    }

    @Override
    public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        AddressResolver<? extends SocketAddress> resolver = this.resolverGroup.getResolver(ctx.executor());
        if (resolver.isSupported(remoteAddress) && !resolver.isResolved(remoteAddress)) {
            resolver.resolve(remoteAddress).addListener((GenericFutureListener<Future<? extends SocketAddress>>)new FutureListener<SocketAddress>(){

                @Override
                public void operationComplete(Future<SocketAddress> future) {
                    Throwable cause = future.cause();
                    if (cause != null) {
                        promise.setFailure(cause);
                    } else {
                        ctx.connect(future.getNow(), localAddress, promise);
                    }
                    ctx.pipeline().remove(ResolveAddressHandler.this);
                }
            });
        } else {
            ctx.connect(remoteAddress, localAddress, promise);
            ctx.pipeline().remove(this);
        }
    }
}

