/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.opentelemetry.testing.internal.io.micrometer.common.KeyValues;
import io.opentelemetry.testing.internal.io.micrometer.common.lang.Nullable;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.http.Outcome;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationDocumentation;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.httpcomponents.hc5.HttpContextUtils;
import java.io.IOException;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;

public class DefaultApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final DefaultApacheHttpClientObservationConvention INSTANCE = new DefaultApacheHttpClientObservationConvention();

    protected DefaultApacheHttpClientObservationConvention() {
    }

    @Override
    public String getName() {
        return "httpcomponents.httpclient.request";
    }

    @Override
    public String getContextualName(ApacheHttpClientContext context) {
        return "HTTP " + this.getMethodString((HttpRequest)context.getCarrier());
    }

    @Override
    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context) {
        KeyValues keyValues = KeyValues.of(ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD.withValue(this.getMethodString((HttpRequest)context.getCarrier())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(context.getUriMapper().apply((HttpRequest)context.getCarrier())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS.withValue(this.getStatusValue((HttpResponse)context.getResponse(), context.getError())), ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME.withValue(this.getStatusOutcome((HttpResponse)context.getResponse()).name()));
        if (context.shouldExportTagsForRoute()) {
            keyValues = keyValues.and(HttpContextUtils.generateTagStringsForRoute(context.getApacheHttpContext()));
        }
        return keyValues;
    }

    Outcome getStatusOutcome(@Nullable HttpResponse response) {
        return response != null ? Outcome.forStatus(response.getCode()) : Outcome.UNKNOWN;
    }

    String getStatusValue(@Nullable HttpResponse response, Throwable error) {
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return "IO_ERROR";
        }
        return response != null ? Integer.toString(response.getCode()) : "CLIENT_ERROR";
    }

    String getMethodString(@Nullable HttpRequest request) {
        return request != null && request.getMethod() != null ? request.getMethod() : "UNKNOWN";
    }
}

