/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.httpcomponents;

import io.opentelemetry.testing.internal.io.micrometer.common.lang.NonNull;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Gauge;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.MeterRegistry;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Tag;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.Tags;
import io.opentelemetry.testing.internal.io.micrometer.core.instrument.binder.MeterBinder;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.pool.ConnPoolControl;

public class PoolingHttpClientConnectionManagerMetricsBinder
implements MeterBinder {
    private final ConnPoolControl<HttpRoute> connPoolControl;
    private final Iterable<Tag> tags;

    public PoolingHttpClientConnectionManagerMetricsBinder(ConnPoolControl<HttpRoute> connPoolControl, String name, String ... tags) {
        this(connPoolControl, name, Tags.of(tags));
    }

    public PoolingHttpClientConnectionManagerMetricsBinder(ConnPoolControl<HttpRoute> connPoolControl, String name, Iterable<Tag> tags) {
        this.connPoolControl = connPoolControl;
        this.tags = Tags.concat(tags, "httpclient", name);
    }

    @Override
    public void bindTo(@NonNull MeterRegistry registry) {
        this.registerTotalMetrics(registry);
    }

    private void registerTotalMetrics(MeterRegistry registry) {
        Gauge.builder("httpcomponents.httpclient.pool.total.max", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getMax()).description("The configured maximum number of allowed persistent connections for all routes.").tags(this.tags).register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.total.connections", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getAvailable()).description("The number of persistent and available connections for all routes.").tags(this.tags).tag("state", "available").register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.total.connections", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getLeased()).description("The number of persistent and leased connections for all routes.").tags(this.tags).tag("state", "leased").register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.total.pending", this.connPoolControl, connPoolControl -> connPoolControl.getTotalStats().getPending()).description("The number of connection requests being blocked awaiting a free connection for all routes.").tags(this.tags).register(registry);
        Gauge.builder("httpcomponents.httpclient.pool.route.max.default", this.connPoolControl, ConnPoolControl::getDefaultMaxPerRoute).description("The configured default maximum number of allowed persistent connections per route.").tags(this.tags).register(registry);
    }
}

