/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.throttling;

import io.opentelemetry.testing.internal.armeria.common.Request;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.util.concurrent.RateLimiter;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.throttling.ThrottlingStrategy;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

final class RateLimitingThrottlingStrategy<T extends Request>
extends ThrottlingStrategy<T> {
    private final RateLimiter rateLimiter;

    RateLimitingThrottlingStrategy(double requestPerSecond, @Nullable String name) {
        super(name);
        Preconditions.checkArgument(requestPerSecond > 0.0, "requestPerSecond: %s (expected: > 0)", (Object)requestPerSecond);
        this.rateLimiter = RateLimiter.create(requestPerSecond);
    }

    RateLimitingThrottlingStrategy(double requestPerSecond) {
        this(requestPerSecond, null);
    }

    RateLimitingThrottlingStrategy(RateLimiter rateLimiter) {
        this.rateLimiter = Objects.requireNonNull(rateLimiter, "rateLimiter");
    }

    @Override
    public CompletionStage<Boolean> accept(ServiceRequestContext ctx, T request) {
        return UnmodifiableFuture.completedFuture(this.rateLimiter.tryAcquire());
    }
}

