/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.logging.LogWriter;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLog;
import io.opentelemetry.testing.internal.armeria.common.util.Sampler;
import io.opentelemetry.testing.internal.armeria.internal.common.logging.LoggingUtils;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.logging.LoggingServiceBuilder;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoggingService
extends SimpleDecoratingHttpService {
    private static final Logger logger = LoggerFactory.getLogger(LoggingService.class);
    private final LogWriter logWriter;
    private final Sampler<? super RequestLog> sampler;

    public static Function<? super HttpService, LoggingService> newDecorator() {
        return LoggingService.builder().newDecorator();
    }

    public static LoggingServiceBuilder builder() {
        return new LoggingServiceBuilder().defaultLogger(logger);
    }

    LoggingService(HttpService delegate, LogWriter logWriter, Sampler<? super ServiceRequestContext> successSampler, Sampler<? super ServiceRequestContext> failureSampler) {
        super(Objects.requireNonNull(delegate, "delegate"));
        this.logWriter = Objects.requireNonNull(logWriter, "logWriter");
        Objects.requireNonNull(successSampler, "successSampler");
        Objects.requireNonNull(failureSampler, "failureSampler");
        this.sampler = requestLog -> {
            ServiceRequestContext ctx = (ServiceRequestContext)requestLog.context();
            if (ctx.config().successFunction().isSuccess(ctx, (RequestLog)requestLog)) {
                return successSampler.isSampled(ctx);
            }
            return failureSampler.isSampled(ctx);
        };
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        ctx.setShouldReportUnhandledExceptions(false);
        ctx.log().whenComplete().thenAccept(requestLog -> {
            if (this.sampler.isSampled((RequestLog)requestLog)) {
                LoggingUtils.log(ctx, requestLog, this.logWriter);
            }
        });
        return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
    }
}

