/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.logging;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.RequestContext;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.logging.ContentPreviewer;
import io.opentelemetry.testing.internal.armeria.common.logging.ContentPreviewerFactory;
import io.opentelemetry.testing.internal.armeria.common.logging.RequestLogProperty;
import io.opentelemetry.testing.internal.armeria.internal.logging.ContentPreviewingUtil;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.logging.ContentPreviewingServiceBuilder;
import io.opentelemetry.testing.internal.io.netty.util.AttributeKey;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;

public final class ContentPreviewingService
extends SimpleDecoratingHttpService {
    private static final AttributeKey<Boolean> SETTING_CONTENT_PREVIEW = AttributeKey.valueOf(ContentPreviewingService.class, "SETTING_CONTENT_PREVIEW");
    private final ContentPreviewerFactory contentPreviewerFactory;
    private final BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer;
    private final BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer;

    public static Function<? super HttpService, ContentPreviewingService> newDecorator(int maxLength) {
        ContentPreviewerFactory factory = ContentPreviewerFactory.text(maxLength);
        return ContentPreviewingService.builder(factory).newDecorator();
    }

    public static Function<? super HttpService, ContentPreviewingService> newDecorator(int maxLength, Charset defaultCharset) {
        ContentPreviewerFactory factory = ContentPreviewerFactory.text(maxLength, defaultCharset);
        return ContentPreviewingService.builder(factory).newDecorator();
    }

    public static Function<? super HttpService, ContentPreviewingService> newDecorator(ContentPreviewerFactory contentPreviewerFactory) {
        return ContentPreviewingService.builder(contentPreviewerFactory).newDecorator();
    }

    public static ContentPreviewingServiceBuilder builder(ContentPreviewerFactory contentPreviewerFactory) {
        return new ContentPreviewingServiceBuilder(Objects.requireNonNull(contentPreviewerFactory, "contentPreviewerFactory"));
    }

    ContentPreviewingService(HttpService delegate, ContentPreviewerFactory contentPreviewerFactory, BiFunction<? super RequestContext, String, ? extends @Nullable Object> requestPreviewSanitizer, BiFunction<? super RequestContext, String, ? extends @Nullable Object> responsePreviewSanitizer) {
        super(delegate);
        this.contentPreviewerFactory = contentPreviewerFactory;
        this.requestPreviewSanitizer = requestPreviewSanitizer;
        this.responsePreviewSanitizer = responsePreviewSanitizer;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        Boolean settingContentPreview = ctx.attr(SETTING_CONTENT_PREVIEW);
        if (Boolean.TRUE.equals(settingContentPreview)) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        }
        ctx.setAttr(SETTING_CONTENT_PREVIEW, true);
        if (!req.isEmpty()) {
            ContentPreviewer requestContentPreviewer = this.contentPreviewerFactory.requestContentPreviewer(ctx, req.headers());
            req = ContentPreviewingUtil.setUpRequestContentPreviewer(ctx, req, requestContentPreviewer, this.requestPreviewSanitizer);
        } else {
            ctx.logBuilder().requestContentPreview("");
        }
        ctx.logBuilder().defer(RequestLogProperty.RESPONSE_CONTENT_PREVIEW);
        HttpResponse res = (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        return ContentPreviewingUtil.setUpResponseContentPreviewer(this.contentPreviewerFactory, ctx, res, this.responsePreviewSanitizer);
    }
}

