/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.healthcheck;

import io.opentelemetry.testing.internal.armeria.common.CommonPools;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.server.healthcheck.HealthCheckStatus;
import io.opentelemetry.testing.internal.armeria.server.healthcheck.ListenableHealthChecker;
import io.opentelemetry.testing.internal.armeria.server.healthcheck.ScheduledHealthChecker;
import io.opentelemetry.testing.internal.io.netty.util.concurrent.EventExecutor;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;

@FunctionalInterface
public interface HealthChecker {
    @UnstableApi
    public static ListenableHealthChecker of(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl) {
        return HealthChecker.of(healthChecker, fallbackTtl, CommonPools.workerGroup().next());
    }

    @UnstableApi
    public static ListenableHealthChecker of(Supplier<? extends CompletionStage<HealthCheckStatus>> healthChecker, Duration fallbackTtl, EventExecutor eventExecutor) {
        Objects.requireNonNull(fallbackTtl, "fallbackTtl");
        Preconditions.checkArgument(!fallbackTtl.isNegative() && !fallbackTtl.isZero(), "fallbackTtl: %s (expected: > 0)", (Object)fallbackTtl);
        return new ScheduledHealthChecker(Objects.requireNonNull(healthChecker, "healthChecker"), fallbackTtl, Objects.requireNonNull(eventExecutor, "eventExecutor"));
    }

    public boolean isHealthy();
}

