/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.file;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.shaded.caffeine.cache.CaffeineSpec;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.MoreObjects;
import io.opentelemetry.testing.internal.armeria.server.file.HttpVfs;
import io.opentelemetry.testing.internal.armeria.server.file.MediaTypeResolver;
import io.opentelemetry.testing.internal.io.netty.util.AsciiString;
import java.time.Clock;
import java.util.Map;
import java.util.Objects;

public final class FileServiceConfig {
    private final HttpVfs vfs;
    private final Clock clock;
    @Nullable
    private final String entryCacheSpec;
    private final int maxCacheEntrySizeBytes;
    private final boolean serveCompressedFiles;
    private final boolean autoDecompress;
    private final boolean autoIndex;
    private final HttpHeaders headers;
    private final MediaTypeResolver mediaTypeResolver;

    FileServiceConfig(HttpVfs vfs, Clock clock, @Nullable String entryCacheSpec, int maxCacheEntrySizeBytes, boolean serveCompressedFiles, boolean autoDecompress, boolean autoIndex, HttpHeaders headers, MediaTypeResolver mediaTypeResolver) {
        this.vfs = Objects.requireNonNull(vfs, "vfs");
        this.clock = Objects.requireNonNull(clock, "clock");
        this.entryCacheSpec = FileServiceConfig.validateEntryCacheSpec(entryCacheSpec);
        this.maxCacheEntrySizeBytes = FileServiceConfig.validateMaxCacheEntrySizeBytes(maxCacheEntrySizeBytes);
        this.serveCompressedFiles = serveCompressedFiles;
        this.autoDecompress = autoDecompress;
        this.autoIndex = autoIndex;
        this.headers = Objects.requireNonNull(headers, "headers");
        this.mediaTypeResolver = Objects.requireNonNull(mediaTypeResolver, "mediaTypeResolver");
    }

    @Nullable
    static String validateEntryCacheSpec(@Nullable String entryCacheSpec) {
        if (entryCacheSpec == null || "off".equals(entryCacheSpec)) {
            return null;
        }
        try {
            CaffeineSpec.parse(entryCacheSpec);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("invalid cache spec: " + entryCacheSpec, e);
        }
        return entryCacheSpec;
    }

    static int validateMaxCacheEntrySizeBytes(int maxCacheEntrySizeBytes) {
        return FileServiceConfig.validateNonNegativeParameter(maxCacheEntrySizeBytes, "maxCacheEntrySizeBytes");
    }

    static int validateNonNegativeParameter(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(name + ": " + value + " (expected: >= 0)");
        }
        return value;
    }

    public HttpVfs vfs() {
        return this.vfs;
    }

    public Clock clock() {
        return this.clock;
    }

    @Nullable
    public String entryCacheSpec() {
        return this.entryCacheSpec;
    }

    public int maxCacheEntrySizeBytes() {
        return this.maxCacheEntrySizeBytes;
    }

    public boolean serveCompressedFiles() {
        return this.serveCompressedFiles;
    }

    public boolean autoDecompress() {
        return this.autoDecompress;
    }

    public boolean autoIndex() {
        return this.autoIndex;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    public MediaTypeResolver mediaTypeResolver() {
        return this.mediaTypeResolver;
    }

    public String toString() {
        return FileServiceConfig.toString(this, this.vfs(), this.clock(), this.entryCacheSpec(), this.maxCacheEntrySizeBytes(), this.serveCompressedFiles(), this.autoIndex(), this.headers(), this.mediaTypeResolver());
    }

    static String toString(Object holder, HttpVfs vfs, Clock clock, @Nullable String entryCacheSpec, int maxCacheEntrySizeBytes, boolean serveCompressedFiles, boolean autoIndex, @Nullable Iterable<Map.Entry<AsciiString, String>> headers, MediaTypeResolver mediaTypeResolver) {
        return MoreObjects.toStringHelper(holder).omitNullValues().add("vfs", vfs).add("clock", clock).add("entryCacheSpec", entryCacheSpec).add("maxCacheEntrySizeBytes", maxCacheEntrySizeBytes).add("serveCompressedFiles", serveCompressedFiles).add("autoIndex", autoIndex).add("headers", headers).add("mediaTypeResolver", mediaTypeResolver).toString();
    }
}

