/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.encoding;

import io.opentelemetry.testing.internal.armeria.common.FilteredHttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.Exceptions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.primitives.Ints;
import io.opentelemetry.testing.internal.armeria.server.encoding.HttpEncoders;
import io.opentelemetry.testing.internal.armeria.server.encoding.HttpEncodingType;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBuf;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.function.Predicate;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpEncodedResponse
extends FilteredHttpResponse {
    private static final Logger logger = LoggerFactory.getLogger(HttpEncodedResponse.class);
    private final HttpEncodingType encodingType;
    private final Predicate<MediaType> encodableContentTypePredicate;
    private final long minBytesToForceChunkedAndEncoding;
    private final ByteBufAllocator alloc;
    @Nullable
    ByteBufOutputStream encodedStream;
    @Nullable
    private OutputStream encodingStream;
    private boolean headersSent;
    private boolean encoderClosed;

    HttpEncodedResponse(HttpResponse delegate, HttpEncodingType encodingType, Predicate<MediaType> encodableContentTypePredicate, ByteBufAllocator alloc, long minBytesToForceChunkedAndEncoding) {
        super(delegate);
        this.encodingType = encodingType;
        this.encodableContentTypePredicate = encodableContentTypePredicate;
        this.alloc = alloc;
        this.minBytesToForceChunkedAndEncoding = minBytesToForceChunkedAndEncoding;
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof ResponseHeaders) {
            ResponseHeaders headers = (ResponseHeaders)obj;
            HttpStatus status = headers.status();
            if (status.isInformational()) {
                return obj;
            }
            if (this.headersSent) {
                return obj;
            }
            this.headersSent = true;
            if (!this.shouldEncodeResponse(headers)) {
                return obj;
            }
            long contentLength = headers.contentLength();
            ByteBuf buf = contentLength > 0L ? this.alloc.buffer(Ints.saturatedCast(contentLength) / 2) : this.alloc.buffer();
            this.encodedStream = new ByteBufOutputStream(buf);
            this.encodingStream = HttpEncoders.getEncodingOutputStream(this.encodingType, this.encodedStream);
            ResponseHeadersBuilder mutable = headers.toBuilder();
            mutable.remove(HttpHeaderNames.CONTENT_LENGTH);
            switch (this.encodingType) {
                case GZIP: {
                    mutable.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, "gzip");
                    break;
                }
                case DEFLATE: {
                    mutable.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, "deflate");
                    break;
                }
                case BROTLI: {
                    mutable.set((CharSequence)HttpHeaderNames.CONTENT_ENCODING, "br");
                }
            }
            mutable.set((CharSequence)HttpHeaderNames.VARY, HttpHeaderNames.ACCEPT_ENCODING.toString());
            return mutable.build();
        }
        if (obj instanceof HttpHeaders) {
            return obj;
        }
        if (this.encodingStream == null) {
            return obj;
        }
        HttpData data = (HttpData)obj;
        assert (this.encodedStream != null);
        try {
            this.encodingStream.write(data.array());
            this.encodingStream.flush();
            ByteBuf encodedBuf = this.encodedStream.buffer();
            HttpData httpData = HttpData.wrap(encodedBuf.retainedSlice());
            encodedBuf.readerIndex(encodedBuf.writerIndex());
            return httpData;
        }
        catch (IOException e) {
            throw new IllegalStateException("Error encoding HttpData, this should not happen with byte arrays.", e);
        }
    }

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        this.closeEncoder(false);
        if (this.encodedStream == null) {
            return;
        }
        ByteBuf buf = this.encodedStream.buffer();
        if (buf.isReadable()) {
            try {
                subscriber.onNext(HttpData.wrap(buf));
            }
            catch (Throwable t) {
                subscriber.onError(t);
                Exceptions.throwIfFatal(t);
                logger.warn("Subscriber.onNext() should not raise an exception. subscriber: {}", subscriber, (Object)t);
            }
        } else {
            buf.release();
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        this.closeEncoder(true);
        return cause;
    }

    @Override
    protected void onCancellation(Subscriber<? super HttpObject> subscriber) {
        this.closeEncoder(true);
    }

    private void closeEncoder(boolean releaseEncodedBuf) {
        if (this.encoderClosed) {
            return;
        }
        this.encoderClosed = true;
        if (this.encodingStream == null) {
            return;
        }
        try {
            this.encodingStream.close();
            if (this.encodedStream != null && releaseEncodedBuf) {
                this.encodedStream.buffer().release();
            }
        }
        catch (IOException e) {
            logger.warn("Unexpected exception is raised while closing the encoding stream.", (Throwable)e);
        }
    }

    private boolean shouldEncodeResponse(ResponseHeaders headers) {
        long contentLength;
        if (headers.status().isContentAlwaysEmpty()) {
            return false;
        }
        if (headers.contains(HttpHeaderNames.CONTENT_ENCODING)) {
            return false;
        }
        if (headers.contentType() != null) {
            try {
                MediaType contentType = headers.contentType();
                if (!this.encodableContentTypePredicate.test(contentType)) {
                    return false;
                }
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ((contentLength = headers.contentLength()) == -1L) {
            contentLength = Long.MAX_VALUE;
        }
        return contentLength >= this.minBytesToForceChunkedAndEncoding;
    }
}

