/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.encoding;

import io.opentelemetry.testing.internal.armeria.common.ContentTooLargeException;
import io.opentelemetry.testing.internal.armeria.common.FilteredHttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpData;
import io.opentelemetry.testing.internal.armeria.common.HttpObject;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoder;
import io.opentelemetry.testing.internal.armeria.common.encoding.StreamDecoderFactory;
import io.opentelemetry.testing.internal.armeria.common.util.CompositeException;
import io.opentelemetry.testing.internal.io.netty.buffer.ByteBufAllocator;
import org.reactivestreams.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class HttpDecodedRequest
extends FilteredHttpRequest {
    private static final Logger logger = LoggerFactory.getLogger(HttpDecodedRequest.class);
    private final StreamDecoder requestDecoder;
    private boolean decoderFinished;

    HttpDecodedRequest(HttpRequest delegate, StreamDecoderFactory decoderFactory, ByteBufAllocator alloc, int maxRequestLength) {
        super(delegate);
        this.requestDecoder = decoderFactory.newDecoder(alloc, maxRequestLength);
    }

    @Override
    protected HttpObject filter(HttpObject obj) {
        if (obj instanceof HttpData) {
            return this.requestDecoder.decode((HttpData)obj);
        }
        return obj;
    }

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        HttpData lastData = this.closeRequestDecoder();
        if (lastData == null) {
            return;
        }
        if (!lastData.isEmpty()) {
            subscriber.onNext(lastData);
        } else {
            lastData.close();
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        try {
            HttpData lastData = this.closeRequestDecoder();
            if (lastData != null) {
                lastData.close();
            }
            return cause;
        }
        catch (Exception decoderException) {
            return new CompositeException(cause, decoderException);
        }
    }

    @Override
    protected void onCancellation(Subscriber<? super HttpObject> subscriber) {
        try {
            HttpData lastData = this.closeRequestDecoder();
            if (lastData != null) {
                lastData.close();
            }
        }
        catch (ContentTooLargeException cause) {
            logger.warn("A request content exceeds the maximum allowed request length. headers: {}", (Object)this.headers(), (Object)cause);
        }
    }

    @Nullable
    private HttpData closeRequestDecoder() {
        if (this.decoderFinished) {
            return null;
        }
        this.decoderFinished = true;
        return this.requestDecoder.finish();
    }
}

