/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.encoding;

import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.encoding.EncodingService;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public final class EncodingServiceBuilder {
    private static final Set<MediaType> defaultEncodableMediaTypsSet = ImmutableSet.of(MediaType.ANY_TEXT_TYPE, MediaType.APPLICATION_XML_UTF_8, MediaType.JAVASCRIPT_UTF_8, MediaType.JSON_UTF_8);
    private static final Predicate<MediaType> defaultEncodableContentTypePredicate = contentType -> {
        for (MediaType encodableMediaType : defaultEncodableMediaTypsSet) {
            if (!contentType.belongsTo(encodableMediaType)) continue;
            return true;
        }
        return false;
    };
    private static final int DEFAULT_MIN_BYTES_TO_FORCE_CHUNKED_AND_ENCODING = 1024;
    private Predicate<MediaType> encodableContentTypePredicate = defaultEncodableContentTypePredicate;
    private Predicate<? super RequestHeaders> encodableRequestHeadersPredicate = headers -> true;
    private int minBytesToForceChunkedAndEncoding = 1024;

    EncodingServiceBuilder() {
    }

    public EncodingServiceBuilder encodableContentTypes(MediaType ... contentTypes) {
        return this.encodableContentTypes(ImmutableList.copyOf(Objects.requireNonNull(contentTypes, "contentTypes")));
    }

    public EncodingServiceBuilder encodableContentTypes(Iterable<MediaType> contentTypes) {
        ImmutableList<MediaType> snapshot = ImmutableList.copyOf(Objects.requireNonNull(contentTypes, "contentTypes"));
        return this.encodableContentTypes((MediaType mediaType) -> snapshot.stream().anyMatch(mediaType::belongsTo));
    }

    public EncodingServiceBuilder encodableContentTypes(Predicate<MediaType> encodableContentTypePredicate) {
        Objects.requireNonNull(encodableContentTypePredicate, "encodableContentTypePredicate");
        this.encodableContentTypePredicate = encodableContentTypePredicate;
        return this;
    }

    public EncodingServiceBuilder encodableRequestHeaders(Predicate<? super RequestHeaders> encodableRequestHeadersPredicate) {
        Objects.requireNonNull(encodableRequestHeadersPredicate, "encodableRequestHeadersPredicate");
        this.encodableRequestHeadersPredicate = encodableRequestHeadersPredicate;
        return this;
    }

    public EncodingServiceBuilder minBytesToForceChunkedEncoding(int minBytesToForceChunkedAndEncoding) {
        Preconditions.checkArgument(minBytesToForceChunkedAndEncoding > 0, "minBytesToForceChunkedAndEncoding: %s (expected: > 0)", minBytesToForceChunkedAndEncoding);
        this.minBytesToForceChunkedAndEncoding = minBytesToForceChunkedAndEncoding;
        return this;
    }

    public EncodingService build(HttpService delegate) {
        return new EncodingService(delegate, this.encodableContentTypePredicate, this.encodableRequestHeadersPredicate, this.minBytesToForceChunkedAndEncoding);
    }

    public Function<? super HttpService, EncodingService> newDecorator() {
        return this::build;
    }
}

