/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.encoding;

import io.opentelemetry.testing.internal.armeria.common.ExchangeType;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.MediaType;
import io.opentelemetry.testing.internal.armeria.common.RequestHeaders;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.RoutingContext;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.encoding.EncodingServiceBuilder;
import io.opentelemetry.testing.internal.armeria.server.encoding.HttpEncodedResponse;
import io.opentelemetry.testing.internal.armeria.server.encoding.HttpEncoders;
import io.opentelemetry.testing.internal.armeria.server.encoding.HttpEncodingType;
import java.util.function.Function;
import java.util.function.Predicate;

public final class EncodingService
extends SimpleDecoratingHttpService {
    private final Predicate<MediaType> encodableContentTypePredicate;
    private final Predicate<? super RequestHeaders> encodableRequestHeadersPredicate;
    private final long minBytesToForceChunkedAndEncoding;

    public static EncodingServiceBuilder builder() {
        return new EncodingServiceBuilder();
    }

    public static Function<? super HttpService, EncodingService> newDecorator() {
        return EncodingService.builder().newDecorator();
    }

    EncodingService(HttpService delegate, Predicate<MediaType> encodableContentTypePredicate, Predicate<? super RequestHeaders> encodableRequestHeadersPredicate, long minBytesToForceChunkedAndEncoding) {
        super(delegate);
        this.encodableContentTypePredicate = encodableContentTypePredicate;
        this.encodableRequestHeadersPredicate = encodableRequestHeadersPredicate;
        this.minBytesToForceChunkedAndEncoding = minBytesToForceChunkedAndEncoding;
    }

    @Override
    public ExchangeType exchangeType(RoutingContext routingContext) {
        return ExchangeType.BIDI_STREAMING;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpEncodingType encodingType = HttpEncoders.getWrapperForRequest(req);
        HttpResponse delegateResponse = (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
        if (encodingType == null || !this.encodableRequestHeadersPredicate.test(req.headers())) {
            return delegateResponse;
        }
        return new HttpEncodedResponse(delegateResponse, encodingType, this.encodableContentTypePredicate, ctx.alloc(), this.minBytesToForceChunkedAndEncoding);
    }
}

