/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.JacksonUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.opentelemetry.testing.internal.armeria.server.docs.ContainerTypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.EnumInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldLocation;
import io.opentelemetry.testing.internal.armeria.server.docs.FieldRequirement;
import io.opentelemetry.testing.internal.armeria.server.docs.MapTypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.MethodInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.ServiceInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.ServiceSpecification;
import io.opentelemetry.testing.internal.armeria.server.docs.StructInfo;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignatureType;
import io.opentelemetry.testing.internal.jackson.databind.ObjectMapper;
import io.opentelemetry.testing.internal.jackson.databind.node.ArrayNode;
import io.opentelemetry.testing.internal.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class JsonSchemaGenerator {
    private static final Logger logger = LoggerFactory.getLogger(JsonSchemaGenerator.class);
    private static final ObjectMapper mapper = JacksonUtil.newDefaultObjectMapper();
    private static final List<FieldLocation> VALID_FIELD_LOCATIONS = ImmutableList.of(FieldLocation.BODY, FieldLocation.UNSPECIFIED);
    private static final List<String> MEMORIZED_JSON_TYPES = ImmutableList.of("array", "object");
    private final Set<ServiceInfo> serviceInfos;
    private final Map<String, StructInfo> typeSignatureToStructMapping;
    private final Map<String, EnumInfo> typeNameToEnumMapping;

    static ArrayNode generate(ServiceSpecification serviceSpecification) {
        JsonSchemaGenerator generator = new JsonSchemaGenerator(serviceSpecification);
        return generator.generate();
    }

    private JsonSchemaGenerator(ServiceSpecification serviceSpecification) {
        this.serviceInfos = serviceSpecification.services();
        ImmutableMap.Builder<String, StructInfo> typeSignatureToStructMappingBuilder = ImmutableMap.builderWithExpectedSize(serviceSpecification.structs().size());
        for (StructInfo struct : serviceSpecification.structs()) {
            typeSignatureToStructMappingBuilder.put(struct.name(), struct);
            if (struct.alias() == null) continue;
            typeSignatureToStructMappingBuilder.put(struct.alias(), struct);
        }
        this.typeSignatureToStructMapping = typeSignatureToStructMappingBuilder.build();
        this.typeNameToEnumMapping = serviceSpecification.enums().stream().collect(ImmutableMap.toImmutableMap(EnumInfo::name, Function.identity()));
    }

    private ArrayNode generate() {
        ArrayNode definitions = mapper.createArrayNode();
        Set methodDefinitions = this.serviceInfos.stream().flatMap(serviceInfo -> serviceInfo.methods().stream().map(this::generate)).collect(ImmutableSet.toImmutableSet());
        return definitions.addAll(methodDefinitions);
    }

    private ObjectNode generate(MethodInfo methodInfo) {
        List<FieldInfo> methodFields;
        ObjectNode root = mapper.createObjectNode();
        root.put("$id", methodInfo.id()).put("title", methodInfo.name()).put("description", methodInfo.descriptionInfo().docString()).put("additionalProperties", false).put("type", "object");
        HashMap<TypeSignature, String> visited = new HashMap<TypeSignature, String>();
        String currentPath = "#";
        if (methodInfo.useParameterAsRoot()) {
            TypeSignature signature = methodInfo.parameters().get(0).typeSignature();
            StructInfo structInfo = this.typeSignatureToStructMapping.get(signature.signature());
            if (structInfo == null) {
                logger.debug("Could not find root parameter with signature: {}", (Object)signature);
                root.put("additionalProperties", true);
                methodFields = ImmutableList.of();
            } else {
                methodFields = structInfo.fields();
            }
            visited.put(signature, "#");
        } else {
            methodFields = methodInfo.parameters();
        }
        this.generateProperties(methodFields, visited, "#", root);
        return root;
    }

    private void generateField(FieldInfo field, Map<TypeSignature, String> visited, String path, ObjectNode parent, @Nullable ArrayNode required) {
        ObjectNode fieldNode = mapper.createObjectNode();
        TypeSignature fieldTypeSignature = field.typeSignature();
        fieldNode.put("description", field.descriptionInfo().docString());
        if (required != null && field.requirement() == FieldRequirement.REQUIRED) {
            required.add(field.name());
        }
        if (visited.containsKey(fieldTypeSignature)) {
            String pathName = visited.get(fieldTypeSignature);
            fieldNode.put("$ref", pathName);
        } else {
            String schemaType = JsonSchemaGenerator.getSchemaType(field.typeSignature());
            fieldNode.put("type", schemaType);
            if (field.typeSignature().type() == TypeSignatureType.ENUM) {
                fieldNode.set("enum", this.getEnumType(field.typeSignature()));
            }
            String currentPath = field.name().isEmpty() ? path : path + '/' + field.name();
            if (MEMORIZED_JSON_TYPES.contains(schemaType)) {
                visited.put(fieldTypeSignature, currentPath);
            }
            if (field.typeSignature().type() == TypeSignatureType.MAP) {
                this.generateMapFields(fieldNode, field, visited, currentPath);
            } else if (field.typeSignature().type() == TypeSignatureType.ITERABLE) {
                this.generateArrayFields(fieldNode, field, visited, currentPath);
            } else if ("object".equals(schemaType)) {
                this.generateStructFields(fieldNode, field, visited, currentPath);
            }
        }
        if (field.name().isEmpty()) {
            parent.setAll(fieldNode);
        } else {
            parent.set(field.name(), fieldNode);
        }
    }

    private void generateProperties(List<FieldInfo> fields, Map<TypeSignature, String> visited, String path, ObjectNode parent) {
        ObjectNode objectNode = mapper.createObjectNode();
        ArrayNode required = mapper.createArrayNode();
        for (FieldInfo field : fields) {
            if (!VALID_FIELD_LOCATIONS.contains((Object)field.location())) continue;
            this.generateField(field, visited, path + "/properties", objectNode, required);
        }
        parent.set("properties", objectNode);
        parent.set("required", required);
    }

    private void generateMapFields(ObjectNode fieldNode, FieldInfo field, Map<TypeSignature, String> visited, String path) {
        ObjectNode additionalProperties = mapper.createObjectNode();
        TypeSignature valueType = ((MapTypeSignature)field.typeSignature()).valueTypeSignature();
        FieldInfo valueFieldInfo = FieldInfo.builder("", valueType).location(FieldLocation.BODY).requirement(FieldRequirement.OPTIONAL).build();
        this.generateField(valueFieldInfo, visited, path + "/additionalProperties", additionalProperties, null);
        fieldNode.set("additionalProperties", additionalProperties);
    }

    private void generateArrayFields(ObjectNode fieldNode, FieldInfo field, Map<TypeSignature, String> visited, String path) {
        ObjectNode items = mapper.createObjectNode();
        TypeSignature itemsType = ((ContainerTypeSignature)field.typeSignature()).typeParameters().get(0);
        FieldInfo itemFieldInfo = FieldInfo.builder("", itemsType).location(FieldLocation.BODY).requirement(FieldRequirement.OPTIONAL).build();
        this.generateField(itemFieldInfo, visited, path + "/items", items, null);
        fieldNode.set("items", items);
    }

    private void generateStructFields(ObjectNode fieldNode, FieldInfo field, Map<TypeSignature, String> visited, String path) {
        StructInfo fieldStructInfo = this.typeSignatureToStructMapping.get(field.typeSignature().signature());
        fieldNode.put("additionalProperties", fieldStructInfo == null);
        if (fieldStructInfo == null) {
            logger.debug("Could not find struct with signature: {}", (Object)field.typeSignature().signature());
        }
        if (fieldStructInfo != null && !fieldStructInfo.fields().isEmpty()) {
            this.generateProperties(fieldStructInfo.fields(), visited, path, fieldNode);
        }
    }

    private ArrayNode getEnumType(TypeSignature type) {
        ArrayNode enumArray = mapper.createArrayNode();
        EnumInfo enumInfo = this.typeNameToEnumMapping.get(type.signature());
        if (enumInfo != null) {
            enumInfo.values().forEach(x -> enumArray.add(x.name()));
        }
        return enumArray;
    }

    private static String getSchemaType(TypeSignature typeSignature) {
        if (typeSignature.type() == TypeSignatureType.ENUM) {
            return "string";
        }
        if (typeSignature.type() == TypeSignatureType.ITERABLE) {
            switch (typeSignature.name().toLowerCase()) {
                case "repeated": 
                case "list": 
                case "array": 
                case "set": {
                    return "array";
                }
            }
            return "object";
        }
        if (typeSignature.type() == TypeSignatureType.MAP) {
            return "object";
        }
        if (typeSignature.type() == TypeSignatureType.BASE) {
            switch (typeSignature.name().toLowerCase()) {
                case "boolean": 
                case "bool": {
                    return "boolean";
                }
                case "short": 
                case "number": 
                case "float": 
                case "double": {
                    return "number";
                }
                case "i": 
                case "i8": 
                case "i16": 
                case "i32": 
                case "i64": 
                case "integer": 
                case "int": 
                case "l32": 
                case "l64": 
                case "long": 
                case "long32": 
                case "long64": 
                case "int32": 
                case "int64": 
                case "uint32": 
                case "uint64": 
                case "sint32": 
                case "sint64": 
                case "fixed32": 
                case "fixed64": 
                case "sfixed32": 
                case "sfixed64": {
                    return "integer";
                }
                case "binary": 
                case "byte": 
                case "bytes": 
                case "string": {
                    return "string";
                }
            }
            return "object";
        }
        return "object";
    }
}

