/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.docs;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.annotation.UnstableApi;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignature;
import io.opentelemetry.testing.internal.armeria.server.docs.TypeSignatureType;
import java.util.Objects;
import java.util.regex.Pattern;

@UnstableApi
class DefaultTypeSignature
implements TypeSignature {
    private static final Pattern BASE_PATTERN = Pattern.compile("^([^.<>]+)$");
    private final TypeSignatureType type;
    private final String name;

    static void checkBaseTypeName(String baseTypeName, String parameterName) {
        Objects.requireNonNull(baseTypeName, parameterName);
        Preconditions.checkArgument(BASE_PATTERN.matcher(baseTypeName).matches(), "%s: %s", (Object)parameterName, (Object)baseTypeName);
    }

    DefaultTypeSignature(TypeSignatureType type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public TypeSignatureType type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultTypeSignature)) {
            return false;
        }
        DefaultTypeSignature that = (DefaultTypeSignature)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return this.signature();
    }
}

