/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.cors;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaderNames;
import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.HttpStatus;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.common.ResponseHeadersBuilder;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.internal.common.ArmeriaHttpUtil;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.Service;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsConfig;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsPolicy;
import io.opentelemetry.testing.internal.armeria.server.cors.CorsServiceBuilder;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CorsService
extends SimpleDecoratingHttpService {
    private static final Logger logger = LoggerFactory.getLogger(CorsService.class);
    static final String ANY_ORIGIN = "*";
    static final String NULL_ORIGIN = "null";
    private final CorsConfig config;

    public static CorsServiceBuilder builderForAnyOrigin() {
        return new CorsServiceBuilder();
    }

    public static CorsServiceBuilder builder(String ... origins) {
        return CorsService.builder(ImmutableList.copyOf(Objects.requireNonNull(origins, "origins")));
    }

    public static CorsServiceBuilder builder(Iterable<String> origins) {
        Objects.requireNonNull(origins, "origins");
        ImmutableList<String> copied = ImmutableList.copyOf(origins);
        if (copied.contains(ANY_ORIGIN)) {
            if (copied.size() > 1) {
                logger.warn("Any origin (*) has been already included. Other origins ({}) will be ignored.", (Object)copied.stream().filter(c -> !ANY_ORIGIN.equals(c)).collect(Collectors.joining(",")));
            }
            return CorsService.builderForAnyOrigin();
        }
        return new CorsServiceBuilder(copied);
    }

    CorsService(HttpService delegate, CorsConfig config) {
        super(delegate);
        this.config = Objects.requireNonNull(config, "config");
    }

    public CorsConfig config() {
        return this.config;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        if (ArmeriaHttpUtil.isCorsPreflightRequest(req.headers())) {
            return this.handleCorsPreflight(ctx, req);
        }
        if (this.config.isShortCircuit() && this.config.getPolicy(req.headers().get(HttpHeaderNames.ORIGIN), ctx.routingContext()) == null) {
            return CorsService.forbidden();
        }
        return ((HttpResponse)((Service)this.unwrap()).serve(ctx, req)).mapHeaders(headers -> {
            ResponseHeadersBuilder builder = headers.toBuilder();
            this.setCorsResponseHeaders(ctx, req, builder);
            return builder.build();
        });
    }

    private HttpResponse handleCorsPreflight(ServiceRequestContext ctx, HttpRequest req) {
        ResponseHeadersBuilder headers = ResponseHeaders.builder(HttpStatus.OK);
        CorsPolicy policy = this.setCorsOrigin(ctx, req, headers);
        if (policy != null) {
            policy.setCorsAllowMethods(headers);
            policy.setCorsAllowHeaders(req.headers(), headers);
            policy.setCorsAllowCredentials(headers);
            policy.setCorsMaxAge(headers);
            policy.setCorsPreflightResponseHeaders(headers);
        }
        return HttpResponse.of(headers.build());
    }

    private void setCorsResponseHeaders(ServiceRequestContext ctx, HttpRequest req, ResponseHeadersBuilder headers) {
        CorsPolicy policy = this.setCorsOrigin(ctx, req, headers);
        if (policy != null) {
            policy.setCorsAllowCredentials(headers);
            policy.setCorsAllowHeaders(req.headers(), headers);
            policy.setCorsExposeHeaders(headers);
        }
    }

    private static HttpResponse forbidden() {
        return HttpResponse.of(HttpStatus.FORBIDDEN);
    }

    @Nullable
    private CorsPolicy setCorsOrigin(ServiceRequestContext ctx, HttpRequest request, ResponseHeadersBuilder headers) {
        String origin = request.headers().get(HttpHeaderNames.ORIGIN);
        if (origin != null) {
            CorsPolicy policy = this.config.getPolicy(origin, ctx.routingContext());
            if (policy == null) {
                logger.debug("{} There is no CORS policy configured for the request origin '{}' and the path '{}'.", new Object[]{ctx, origin, ctx.path()});
                return null;
            }
            if (NULL_ORIGIN.equals(origin)) {
                CorsService.setCorsNullOrigin(headers);
                return policy;
            }
            if (this.config.isAnyOriginSupported()) {
                if (policy.isCredentialsAllowed()) {
                    CorsService.echoCorsRequestOrigin(request, headers);
                    CorsService.setCorsVaryHeader(headers);
                } else {
                    CorsService.setCorsAnyOrigin(headers);
                }
                return policy;
            }
            CorsService.setCorsOrigin(headers, origin);
            CorsService.setCorsVaryHeader(headers);
            return policy;
        }
        return null;
    }

    private static void setCorsOrigin(ResponseHeadersBuilder headers, String origin) {
        headers.set((CharSequence)HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, origin);
    }

    private static void echoCorsRequestOrigin(HttpRequest request, ResponseHeadersBuilder headers) {
        String origin = request.headers().get(HttpHeaderNames.ORIGIN);
        if (origin != null) {
            CorsService.setCorsOrigin(headers, origin);
        }
    }

    private static void setCorsVaryHeader(ResponseHeadersBuilder headers) {
        headers.set((CharSequence)HttpHeaderNames.VARY, HttpHeaderNames.ORIGIN.toString());
    }

    private static void setCorsAnyOrigin(ResponseHeadersBuilder headers) {
        CorsService.setCorsOrigin(headers, ANY_ORIGIN);
    }

    private static void setCorsNullOrigin(ResponseHeadersBuilder headers) {
        CorsService.setCorsOrigin(headers, NULL_ORIGIN);
    }
}

