/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.auth;

import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.common.util.UnmodifiableFuture;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.base.Preconditions;
import io.opentelemetry.testing.internal.armeria.internal.shaded.guava.collect.ImmutableList;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.auth.AbstractAuthorizerWithHandlers;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthFailureHandler;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthorizationStatus;
import io.opentelemetry.testing.internal.armeria.server.auth.Authorizer;
import io.opentelemetry.testing.internal.armeria.server.auth.AuthorizerUtil;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

final class AuthorizerChain<T>
extends AbstractAuthorizerWithHandlers<T> {
    private final List<? extends Authorizer<T>> authorizers;
    private final AuthorizerSelectionStrategy selectionStrategy;

    private AuthorizerChain(List<? extends Authorizer<T>> authorizers, AuthorizerSelectionStrategy selectionStrategy) {
        Objects.requireNonNull(authorizers, "authorizers");
        this.authorizers = ImmutableList.copyOf(authorizers);
        Preconditions.checkArgument(!this.authorizers.isEmpty(), "authorizers are empty");
        this.selectionStrategy = Objects.requireNonNull(selectionStrategy, "selectionStrategy");
    }

    AuthorizerChain(Authorizer<T> firstAuthorizer, AuthorizerSelectionStrategy selectionStrategy) {
        this(firstAuthorizer instanceof AuthorizerChain ? ((AuthorizerChain)firstAuthorizer).authorizers : ImmutableList.of(firstAuthorizer), selectionStrategy);
    }

    @Override
    public Authorizer<T> orElse(Authorizer<T> nextAuthorizer) {
        ImmutableList.Builder newAuthorizersBuilder = ImmutableList.builder();
        newAuthorizersBuilder.addAll(this.authorizers);
        Objects.requireNonNull(nextAuthorizer, "nextAuthorizer");
        if (nextAuthorizer instanceof AuthorizerChain) {
            newAuthorizersBuilder.addAll(((AuthorizerChain)nextAuthorizer).authorizers);
        } else {
            newAuthorizersBuilder.add(nextAuthorizer);
        }
        return new AuthorizerChain<T>(newAuthorizersBuilder.build(), this.selectionStrategy);
    }

    @Override
    public CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(ServiceRequestContext ctx, @Nullable T data) {
        return this.authorizeAndSupplyHandlers(this.authorizers.iterator(), true, null, ctx, data);
    }

    private CompletionStage<AuthorizationStatus> authorizeAndSupplyHandlers(Iterator<? extends Authorizer<T>> iterator, boolean first, @Nullable AuthFailureHandler prevFailureHandler, ServiceRequestContext ctx, @Nullable T data) {
        Authorizer<T> nextAuthorizer = iterator.next();
        return AuthorizerUtil.authorizeAndSupplyHandlers(nextAuthorizer, ctx, data).thenComposeAsync(result -> {
            AuthFailureHandler failureHandler;
            if (result == null) {
                throw AuthorizerUtil.newNullResultException(nextAuthorizer);
            }
            if (result.isAuthorized()) {
                return UnmodifiableFuture.completedFuture(AuthorizationStatus.ofSuccess(result.successHandler()));
            }
            AuthFailureHandler nextFailureHandler = result.failureHandler();
            switch (this.selectionStrategy) {
                case FIRST: {
                    if (first) {
                        failureHandler = nextFailureHandler;
                        break;
                    }
                    failureHandler = prevFailureHandler;
                    break;
                }
                case FIRST_WITH_HANDLER: {
                    if (prevFailureHandler == null && nextFailureHandler != null) {
                        failureHandler = nextFailureHandler;
                        break;
                    }
                    failureHandler = prevFailureHandler;
                    break;
                }
                case LAST_WITH_HANDLER: {
                    if (nextFailureHandler != null) {
                        failureHandler = nextFailureHandler;
                        break;
                    }
                    failureHandler = prevFailureHandler;
                    break;
                }
                default: {
                    failureHandler = prevFailureHandler;
                }
            }
            if (!iterator.hasNext()) {
                return UnmodifiableFuture.completedFuture(AuthorizationStatus.ofFailure(this.selectionStrategy == AuthorizerSelectionStrategy.LAST ? nextFailureHandler : failureHandler));
            }
            return this.authorizeAndSupplyHandlers(iterator, false, failureHandler, ctx, data);
        }, ctx.eventLoop());
    }

    public String toString() {
        return this.authorizers.toString();
    }

    static enum AuthorizerSelectionStrategy {
        FIRST,
        LAST,
        FIRST_WITH_HANDLER,
        LAST_WITH_HANDLER;

    }
}

