/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.annotation.decorator;

import io.opentelemetry.testing.internal.armeria.common.HttpRequest;
import io.opentelemetry.testing.internal.armeria.common.HttpResponse;
import io.opentelemetry.testing.internal.armeria.common.util.TimeoutMode;
import io.opentelemetry.testing.internal.armeria.server.HttpService;
import io.opentelemetry.testing.internal.armeria.server.ServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.SimpleDecoratingHttpService;
import io.opentelemetry.testing.internal.armeria.server.annotation.DecoratorFactoryFunction;
import io.opentelemetry.testing.internal.armeria.server.annotation.decorator.RequestTimeout;
import java.util.function.Function;

public final class RequestTimeoutDecoratorFunction
implements DecoratorFactoryFunction<RequestTimeout> {
    @Override
    public Function<? super HttpService, ? extends HttpService> newDecorator(RequestTimeout parameter) {
        final long timeoutMillis = parameter.unit().toMillis(parameter.value());
        return delegate -> new SimpleDecoratingHttpService((HttpService)delegate, (HttpService)delegate){
            final /* synthetic */ HttpService val$delegate;
            {
                this.val$delegate = httpService;
                super(delegate);
            }

            @Override
            public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
                if (timeoutMillis <= 0L) {
                    ctx.clearRequestTimeout();
                } else {
                    ctx.setRequestTimeoutMillis(TimeoutMode.SET_FROM_START, timeoutMillis);
                }
                return this.val$delegate.serve(ctx, req);
            }
        };
    }
}

