/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server.annotation;

import io.opentelemetry.testing.internal.armeria.common.HttpHeaders;
import io.opentelemetry.testing.internal.armeria.common.annotation.Nullable;
import io.opentelemetry.testing.internal.armeria.server.annotation.HttpResult;
import java.util.Objects;

final class DefaultHttpResult<T>
implements HttpResult<T> {
    private final HttpHeaders headers;
    @Nullable
    private final T content;
    private final HttpHeaders trailers;

    DefaultHttpResult(HttpHeaders headers) {
        this(headers, null, HttpHeaders.of());
    }

    DefaultHttpResult(HttpHeaders headers, T content) {
        this(headers, Objects.requireNonNull(content, "content"), HttpHeaders.of());
    }

    DefaultHttpResult(HttpHeaders headers, @Nullable T content, HttpHeaders trailers) {
        this.headers = Objects.requireNonNull(headers, "headers");
        this.content = content;
        this.trailers = Objects.requireNonNull(trailers, "trailers");
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T content() {
        return this.content;
    }

    @Override
    public HttpHeaders trailers() {
        return this.trailers;
    }
}

