/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.testing.internal.armeria.server;

import io.opentelemetry.testing.internal.armeria.common.ResponseHeaders;
import io.opentelemetry.testing.internal.armeria.internal.common.HttpHeadersUtil;
import io.opentelemetry.testing.internal.armeria.internal.server.DefaultServiceRequestContext;
import io.opentelemetry.testing.internal.armeria.server.AbstractHttpResponseSubscriber;
import io.opentelemetry.testing.internal.armeria.server.DecodedHttpRequest;
import io.opentelemetry.testing.internal.armeria.server.ServerConfig;
import io.opentelemetry.testing.internal.armeria.server.ServerHttpObjectEncoder;
import io.opentelemetry.testing.internal.io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;

final class WebSocketHttp1ResponseSubscriber
extends AbstractHttpResponseSubscriber {
    WebSocketHttp1ResponseSubscriber(ChannelHandlerContext ctx, ServerHttpObjectEncoder responseEncoder, DefaultServiceRequestContext reqCtx, DecodedHttpRequest req, CompletableFuture<Void> completionFuture) {
        super(ctx, responseEncoder, reqCtx, req, completionFuture);
        responseEncoder.keepAliveHandler().disconnectWhenFinished();
    }

    @Override
    void onResponseHeaders(ResponseHeaders headers) {
        boolean endOfStream = headers.isEndOfStream();
        ServerConfig config = this.reqCtx.config().server().config();
        ResponseHeaders merged = HttpHeadersUtil.mergeResponseHeaders(headers, this.reqCtx.additionalResponseHeaders(), this.reqCtx.config().defaultHeaders(), config.isServerHeaderEnabled(), config.isDateHeaderEnabled());
        this.logBuilder().responseHeaders(merged);
        this.setState(AbstractHttpResponseSubscriber.State.NEEDS_DATA);
        this.responseEncoder.writeHeaders(this.req.id(), this.req.streamId(), merged, endOfStream).addListener(this.writeHeadersFutureListener(endOfStream));
    }
}

